
;CodeVisionAVR C Compiler V2.04.4a Advanced
;(C) Copyright 1998-2009 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type                : ATmega88P
;Program type             : Application
;Clock frequency          : 20,000000 MHz
;Memory model             : Small
;Optimize for             : Speed
;(s)printf features       : int, width
;(s)scanf features        : int, width
;External RAM size        : 0
;Data Stack size          : 256 byte(s)
;Heap size                : 0 byte(s)
;Promote 'char' to 'int'  : No
;'char' is unsigned       : Yes
;8 bit enums              : No
;global 'const' stored in FLASH: Yes
;Enhanced core instructions    : On
;Smart register allocation     : On
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATmega88P
	#pragma AVRPART MEMORY PROG_FLASH 8192
	#pragma AVRPART MEMORY EEPROM 512
	#pragma AVRPART MEMORY INT_SRAM SIZE 1024
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x100

	.LISTMAC
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU EECR=0x1F
	.EQU EEDR=0x20
	.EQU EEARL=0x21
	.EQU EEARH=0x22
	.EQU SPSR=0x2D
	.EQU SPDR=0x2E
	.EQU SMCR=0x33
	.EQU MCUSR=0x34
	.EQU MCUCR=0x35
	.EQU WDTCSR=0x60
	.EQU UCSR0A=0xC0
	.EQU UDR0=0xC6
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F
	.EQU GPIOR0=0x1E

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ANDI R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ORI  R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __CLRD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+(@1))
	LDI  R31,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	LDI  R22,BYTE3(2*@0+(@1))
	LDI  R23,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+(@2))
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+(@3))
	LDI  R@1,HIGH(@2+(@3))
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+(@3))
	LDI  R@1,HIGH(@2*2+(@3))
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+(@1)
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+(@1)
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	LDS  R22,@0+(@1)+2
	LDS  R23,@0+(@1)+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+(@2)
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+(@3)
	LDS  R@1,@2+(@3)+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+(@1)
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	LDS  R24,@0+(@1)+2
	LDS  R25,@0+(@1)+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+(@1),R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	STS  @0+(@1)+2,R22
	STS  @0+(@1)+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+(@1),R0
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+(@1),R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+(@1),R@2
	STS  @0+(@1)+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTBSR
	STD  Y+@1,R@0
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	RCALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __GETD1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X+
	LD   R22,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	RCALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __GETBRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	LD   R@0,X
	.ENDM

	.MACRO __GETWRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	LD   R@0,X+
	LD   R@1,X
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	ST   Z,R@0
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _CV=R4
	.DEF _V=R6

	.CSEG
	.ORG 0x00

;INTERRUPT VECTORS
	RJMP __RESET
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP _timer1_compa_isr
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00

_0x1A:
	.DB  0x0,0x0,0x0,0x0

__GLOBAL_INI_TBL:
	.DW  0x04
	.DW  0x04
	.DW  _0x1A*2

_0xFFFFFFFF:
	.DW  0

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  MCUCR,R31
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	WDR
	IN   R26,MCUSR
	CBR  R26,8
	OUT  MCUSR,R26
	STS  WDTCSR,R31
	STS  WDTCSR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(0x400)
	LDI  R25,HIGH(0x400)
	LDI  R26,LOW(0x100)
	LDI  R27,HIGH(0x100)
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;GPIOR0 INITIALIZATION
	LDI  R30,0x00
	OUT  GPIOR0,R30

;STACK POINTER INITIALIZATION
	LDI  R30,LOW(0x4FF)
	OUT  SPL,R30
	LDI  R30,HIGH(0x4FF)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(0x200)
	LDI  R29,HIGH(0x200)

	RJMP _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x200

	.CSEG
;/*****************************************************
;This program was produced by the
;CodeWizardAVR V2.04.4a Advanced
;Automatic Program Generator
; Copyright 1998-2009 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com
;
;Project :
;Version : 2.9
;Date    : 07.05.2015
;Author  : SYR-ALEX
;Company :
;Comments: 480256  384256   128
;
;
;Chip type               : ATmega88P
;Program type            : Application
;AVR Core Clock frequency: 20 MHz
;Memory model            : Small
;External RAM size       : 0
;Data Stack size         : 256
;*****************************************************/
;
;#include <mega88p.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x01
	.EQU __sm_mask=0x0E
	.EQU __sm_adc_noise_red=0x02
	.EQU __sm_powerdown=0x04
	.EQU __sm_powersave=0x06
	.EQU __sm_standby=0x0C
	.EQU __sm_ext_standby=0x0E
	.SET power_ctrl_reg=smcr
	#endif
;
;#include <delay.h>
;
;#define Hs PORTB.2
;#define Vs PORTB.1
;#define Blank PORTB.3
;#define Strob PORTB.4
;#define Skr PINB.5        //   384\512
;#asm(".EQU PORTC=0x08")
	.EQU PORTC=0x08
;#asm(".EQU PORTB=0x05")
	.EQU PORTB=0x05
;
; unsigned int CV=0 ;//   
; int V=0;           //   
;
;
;
;// Timer1 output compare A interrupt service routine
;interrupt [TIM1_COMPA] void timer1_compa_isr(void)
; 0000 002B {

	.CSEG
_timer1_compa_isr:
	ST   -Y,R24
	ST   -Y,R25
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 002C   if ( CV==312 )
	LDI  R30,LOW(312)
	LDI  R31,HIGH(312)
	CP   R30,R4
	CPC  R31,R5
	BRNE _0x3
; 0000 002D          {
; 0000 002E          CV=0;
	CLR  R4
	CLR  R5
; 0000 002F                 delay_us(160);
	__DELAY_USW 800
; 0000 0030                     Hs=0;Vs=1;
	CBI  0x5,2
	SBI  0x5,1
; 0000 0031                         delay_us(160);
	__DELAY_USW 800
; 0000 0032                    Hs=1;Vs=0;
	SBI  0x5,2
	CBI  0x5,1
; 0000 0033                     //delay_us(100);
; 0000 0034                    goto L1;
	RJMP _0xC
; 0000 0035                     }
; 0000 0036                     else{
_0x3:
; 0000 0037                         if (CV<36)//   
	LDI  R30,LOW(36)
	LDI  R31,HIGH(36)
	CP   R4,R30
	CPC  R5,R31
	BRSH _0xE
; 0000 0038                         {
; 0000 0039                         V=0 ;
	CLR  R6
	CLR  R7
; 0000 003A                         //Blank=1;
; 0000 003B                         goto L1;
	RJMP _0xC
; 0000 003C                           }
; 0000 003D                          else{
_0xE:
; 0000 003E                           PORTD=V;
	OUT  0xB,R6
; 0000 003F                             if (V>255){
	LDI  R30,LOW(255)
	LDI  R31,HIGH(255)
	CP   R30,R6
	CPC  R31,R7
	BRGE _0x10
; 0000 0040                             //Blank=0;
; 0000 0041                             goto L1;}
	RJMP _0xC
; 0000 0042                                 // else{delay_us (5);}
; 0000 0043                                   }
_0x10:
; 0000 0044 
; 0000 0045       }
; 0000 0046       if (Skr==0){goto L384;}
	SBIS 0x3,5
	RJMP _0x12
; 0000 0047                 else{goto L480;}
	RJMP _0x14
; 0000 0048    L384:
_0x12:
; 0000 0049 
; 0000 004A  #asm
; 0000 004B 

; 0000 004C  nop;
 nop;
; 0000 004D 

; 0000 004E  nop;
 nop;
; 0000 004F  nop;
 nop;
; 0000 0050  nop;
 nop;
; 0000 0051  nop;
 nop;
; 0000 0052  nop;
 nop;
; 0000 0053  nop;
 nop;
; 0000 0054  nop;
 nop;
; 0000 0055  nop;
 nop;
; 0000 0056  nop;
 nop;
; 0000 0057  nop;
 nop;
; 0000 0058  nop;
 nop;
; 0000 0059  nop;
 nop;
; 0000 005A  nop;
 nop;
; 0000 005B  nop;
 nop;
; 0000 005C  nop;
 nop;
; 0000 005D   nop;
  nop;
; 0000 005E  nop;
 nop;
; 0000 005F  nop;
 nop;
; 0000 0060  nop;
 nop;
; 0000 0061  nop;
 nop;
; 0000 0062  nop;
 nop;
; 0000 0063  nop;
 nop;
; 0000 0064  nop;
 nop;
; 0000 0065  nop;
 nop;
; 0000 0066  nop;
 nop;
; 0000 0067  nop;
 nop;
; 0000 0068  nop;
 nop;
; 0000 0069  nop;
 nop;
; 0000 006A  nop;
 nop;
; 0000 006B  nop;
 nop;
; 0000 006C  nop;
 nop;
; 0000 006D   nop;
  nop;
; 0000 006E  nop;
 nop;
; 0000 006F  nop;
 nop;
; 0000 0070  nop;
 nop;
; 0000 0071  nop;
 nop;
; 0000 0072  nop;
 nop;
; 0000 0073  nop;
 nop;
; 0000 0074  nop;
 nop;
; 0000 0075  nop;
 nop;
; 0000 0076  nop;
 nop;
; 0000 0077  nop;
 nop;
; 0000 0078  nop;
 nop;
; 0000 0079  nop;
 nop;
; 0000 007A  nop;
 nop;
; 0000 007B  nop;
 nop;
; 0000 007C  nop;
 nop;
; 0000 007D   nop;
  nop;
; 0000 007E  nop;
 nop;
; 0000 007F  nop;
 nop;
; 0000 0080  nop;
 nop;
; 0000 0081  nop;
 nop;
; 0000 0082  nop;
 nop;
; 0000 0083  nop;
 nop;
; 0000 0084  nop;
 nop;
; 0000 0085  nop;
 nop;
; 0000 0086  nop;
 nop;
; 0000 0087  nop;
 nop;
; 0000 0088  nop;
 nop;
; 0000 0089  nop;
 nop;
; 0000 008A  nop;
 nop;
; 0000 008B  nop;
 nop;
; 0000 008C  nop;
 nop;
; 0000 008D   nop;
  nop;
; 0000 008E  nop;
 nop;
; 0000 008F  nop;
 nop;
; 0000 0090  nop;
 nop;
; 0000 0091  nop;
 nop;
; 0000 0092  nop;
 nop;
; 0000 0093  nop;
 nop;
; 0000 0094  nop;
 nop;
; 0000 0095  nop;
 nop;
; 0000 0096  nop;
 nop;
; 0000 0097  nop;
 nop;
; 0000 0098  nop;
 nop;
; 0000 0099  nop;
 nop;
; 0000 009A  nop;
 nop;
; 0000 009B  nop;
 nop;
; 0000 009C  nop;
 nop;
; 0000 009D   nop;
  nop;
; 0000 009E  nop;
 nop;
; 0000 009F  nop;
 nop;
; 0000 00A0  nop;
 nop;
; 0000 00A1  nop;
 nop;
; 0000 00A2  nop;
 nop;
; 0000 00A3  nop;
 nop;
; 0000 00A4  nop;
 nop;
; 0000 00A5  nop;
 nop;
; 0000 00A6  nop;
 nop;
; 0000 00A7  nop;
 nop;
; 0000 00A8  nop;
 nop;
; 0000 00A9  nop;
 nop;
; 0000 00AA  nop;
 nop;
; 0000 00AB  nop;
 nop;
; 0000 00AC  nop;
 nop;
; 0000 00AD   nop;
  nop;
; 0000 00AE  nop;
 nop;
; 0000 00AF  nop;
 nop;
; 0000 00B0  nop;
 nop;
; 0000 00B1  nop;
 nop;
; 0000 00B2  nop;
 nop;
; 0000 00B3  nop;
 nop;
; 0000 00B4  nop;
 nop;
; 0000 00B5  nop;
 nop;
; 0000 00B6  nop;
 nop;
; 0000 00B7  nop;
 nop;
; 0000 00B8  nop;
 nop;
; 0000 00B9  nop;
 nop;
; 0000 00BA  nop;
 nop;
; 0000 00BB  nop;
 nop;
; 0000 00BC  nop;
 nop;
; 0000 00BD   nop;
  nop;
; 0000 00BE  nop;
 nop;
; 0000 00BF  nop;
 nop;
; 0000 00C0  nop;
 nop;
; 0000 00C1  nop;
 nop;
; 0000 00C2  nop;
 nop;
; 0000 00C3  nop;
 nop;
; 0000 00C4  nop;
 nop;
; 0000 00C5  nop;
 nop;
; 0000 00C6  nop;
 nop;
; 0000 00C7  nop;
 nop;
; 0000 00C8  nop;
 nop;
; 0000 00C9  nop;
 nop;
; 0000 00CA  nop;
 nop;
; 0000 00CB  nop;
 nop;
; 0000 00CC  nop;
 nop;
; 0000 00CD   nop;
  nop;
; 0000 00CE  nop;
 nop;
; 0000 00CF  nop;
 nop;
; 0000 00D0  nop;
 nop;
; 0000 00D1  nop;
 nop;
; 0000 00D2  nop;
 nop;
; 0000 00D3  nop;
 nop;
; 0000 00D4  nop;
 nop;
; 0000 00D5  nop;
 nop;
; 0000 00D6  nop;
 nop;
; 0000 00D7  nop;
 nop;
; 0000 00D8  nop;
 nop;
; 0000 00D9  nop;
 nop;
; 0000 00DA  nop;
 nop;
; 0000 00DB  nop;
 nop;
; 0000 00DC  nop;
 nop;
; 0000 00DD   nop;
  nop;
; 0000 00DE  nop;
 nop;
; 0000 00DF  nop;
 nop;
; 0000 00E0  nop;
 nop;
; 0000 00E1  nop;
 nop;
; 0000 00E2  nop;
 nop;
; 0000 00E3  nop;
 nop;
; 0000 00E4  nop;
 nop;
; 0000 00E5  nop;
 nop;
; 0000 00E6  nop;
 nop;
; 0000 00E7  nop;
 nop;
; 0000 00E8  nop;
 nop;
; 0000 00E9  nop;
 nop;
; 0000 00EA  nop;
 nop;
; 0000 00EB  nop;
 nop;
; 0000 00EC  nop;
 nop;
; 0000 00ED   nop;
  nop;
; 0000 00EE  nop;
 nop;
; 0000 00EF  nop;
 nop;
; 0000 00F0  nop;
 nop;
; 0000 00F1  nop;
 nop;
; 0000 00F2  nop;
 nop;
; 0000 00F3  nop;
 nop;
; 0000 00F4  nop;
 nop;
; 0000 00F5  nop;
 nop;
; 0000 00F6  nop;
 nop;
; 0000 00F7  nop;
 nop;
; 0000 00F8  nop;
 nop;
; 0000 00F9  nop;
 nop;
; 0000 00FA  nop;
 nop;
; 0000 00FB  nop;
 nop;
; 0000 00FC  nop;
 nop;
; 0000 00FD   nop;
  nop;
; 0000 00FE  nop;
 nop;
; 0000 00FF  nop;
 nop;
; 0000 0100  nop;
 nop;
; 0000 0101  nop;
 nop;
; 0000 0102  nop;
 nop;
; 0000 0103  nop;
 nop;
; 0000 0104  nop;
 nop;
; 0000 0105  nop;
 nop;
; 0000 0106  nop;
 nop;
; 0000 0107  nop;
 nop;
; 0000 0108  nop;
 nop;
; 0000 0109  nop;
 nop;
; 0000 010A  nop;
 nop;
; 0000 010B  nop;
 nop;
; 0000 010C  nop;
 nop;
; 0000 010D   nop;
  nop;
; 0000 010E  nop;
 nop;
; 0000 010F  nop;
 nop;
; 0000 0110  nop;
 nop;
; 0000 0111  nop;
 nop;
; 0000 0112  nop;
 nop;
; 0000 0113  nop;
 nop;
; 0000 0114  nop;
 nop;
; 0000 0115  nop;
 nop;
; 0000 0116  nop;
 nop;
; 0000 0117  nop;
 nop;
; 0000 0118  nop;
 nop;
; 0000 0119  nop;
 nop;
; 0000 011A  nop;
 nop;
; 0000 011B  nop;
 nop;
; 0000 011C  nop;
 nop;
; 0000 011D   nop;
  nop;
; 0000 011E  nop;
 nop;
; 0000 011F  nop;
 nop;
; 0000 0120  nop;
 nop;
; 0000 0121  nop;
 nop;
; 0000 0122  nop;
 nop;
; 0000 0123  nop;
 nop;
; 0000 0124  nop;
 nop;
; 0000 0125  nop;
 nop;
; 0000 0126  nop;
 nop;
; 0000 0127  nop;
 nop;
; 0000 0128  nop;
 nop;
; 0000 0129  nop;
 nop;
; 0000 012A  nop;
 nop;
; 0000 012B  nop;
 nop;
; 0000 012C  nop;
 nop;
; 0000 012D   nop;
  nop;
; 0000 012E 

; 0000 012F    out PORTC,r19 ;1-0
   out PORTC,r19 ;1-0
; 0000 0130 nop ;2
nop ;2
; 0000 0131 nop ;3
nop ;3
; 0000 0132 nop ;4
nop ;4
; 0000 0133 nop ;5
nop ;5
; 0000 0134 nop ;6
nop ;6
; 0000 0135 nop ;7
nop ;7
; 0000 0136 nop ;8
nop ;8
; 0000 0137 ;nop ;9
;nop ;9
; 0000 0138 cbi PORTB,4 ;10-11 Strob ON
cbi PORTB,4 ;10-11 Strob ON
; 0000 0139 SBI PORTB,4 ;12-13 Strob OFF
SBI PORTB,4 ;12-13 Strob OFF
; 0000 013A sbi PORTB,3 ;14-15 Blank 1
sbi PORTB,3 ;14-15 Blank 1
; 0000 013B     inc r19 ;16
    inc r19 ;16
; 0000 013C     out PORTC,r19 ;1-1
    out PORTC,r19 ;1-1
; 0000 013D nop ;2
nop ;2
; 0000 013E nop ;3
nop ;3
; 0000 013F nop ;4
nop ;4
; 0000 0140 nop ;5
nop ;5
; 0000 0141 nop ;6
nop ;6
; 0000 0142 nop ;7
nop ;7
; 0000 0143 nop ;8
nop ;8
; 0000 0144 nop ;9
nop ;9
; 0000 0145 nop ;10
nop ;10
; 0000 0146 ;nop ;11
;nop ;11
; 0000 0147 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0148 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0149     inc r19 ;16
    inc r19 ;16
; 0000 014A     out PORTC,r19 ;1-2
    out PORTC,r19 ;1-2
; 0000 014B nop ;2
nop ;2
; 0000 014C nop ;3
nop ;3
; 0000 014D nop ;4
nop ;4
; 0000 014E nop ;5
nop ;5
; 0000 014F nop ;6
nop ;6
; 0000 0150 nop ;7
nop ;7
; 0000 0151 nop ;8
nop ;8
; 0000 0152 nop ;9
nop ;9
; 0000 0153 nop ;10
nop ;10
; 0000 0154 ;nop ;11
;nop ;11
; 0000 0155 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0156 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0157     inc r19 ;16
    inc r19 ;16
; 0000 0158     out PORTC,r19 ;1-3
    out PORTC,r19 ;1-3
; 0000 0159 nop ;2
nop ;2
; 0000 015A nop ;3
nop ;3
; 0000 015B nop ;4
nop ;4
; 0000 015C nop ;5
nop ;5
; 0000 015D nop ;6
nop ;6
; 0000 015E nop ;7
nop ;7
; 0000 015F nop ;8
nop ;8
; 0000 0160 nop ;9
nop ;9
; 0000 0161 nop ;10
nop ;10
; 0000 0162 ;nop ;11
;nop ;11
; 0000 0163 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0164 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0165     inc r19 ;16
    inc r19 ;16
; 0000 0166     out PORTC,r19 ;1-4
    out PORTC,r19 ;1-4
; 0000 0167 nop ;2
nop ;2
; 0000 0168 nop ;3
nop ;3
; 0000 0169 nop ;4
nop ;4
; 0000 016A nop ;5
nop ;5
; 0000 016B nop ;6
nop ;6
; 0000 016C nop ;7
nop ;7
; 0000 016D nop ;8
nop ;8
; 0000 016E nop ;9
nop ;9
; 0000 016F nop ;10
nop ;10
; 0000 0170 ;nop ;11
;nop ;11
; 0000 0171 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0172 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0173     inc r19 ;16
    inc r19 ;16
; 0000 0174     out PORTC,r19 ;1-5
    out PORTC,r19 ;1-5
; 0000 0175 nop ;2
nop ;2
; 0000 0176 nop ;3
nop ;3
; 0000 0177 nop ;4
nop ;4
; 0000 0178 nop ;5
nop ;5
; 0000 0179 nop ;6
nop ;6
; 0000 017A nop ;7
nop ;7
; 0000 017B nop ;8
nop ;8
; 0000 017C nop ;9
nop ;9
; 0000 017D nop ;10
nop ;10
; 0000 017E ;nop ;11
;nop ;11
; 0000 017F cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0180 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0181     inc r19 ;16
    inc r19 ;16
; 0000 0182     out PORTC,r19 ;1-6
    out PORTC,r19 ;1-6
; 0000 0183 nop ;2
nop ;2
; 0000 0184 nop ;3
nop ;3
; 0000 0185 nop ;4
nop ;4
; 0000 0186 nop ;5
nop ;5
; 0000 0187 nop ;6
nop ;6
; 0000 0188 nop ;7
nop ;7
; 0000 0189 nop ;8
nop ;8
; 0000 018A nop ;9
nop ;9
; 0000 018B nop ;10
nop ;10
; 0000 018C nop ;11
nop ;11
; 0000 018D cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 018E SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 018F     inc r19 ;16
    inc r19 ;16
; 0000 0190     out PORTC,r19 ;1-7
    out PORTC,r19 ;1-7
; 0000 0191 nop ;2
nop ;2
; 0000 0192 nop ;3
nop ;3
; 0000 0193 nop ;4
nop ;4
; 0000 0194 nop ;5
nop ;5
; 0000 0195 nop ;6
nop ;6
; 0000 0196 nop ;7
nop ;7
; 0000 0197 nop ;8
nop ;8
; 0000 0198 nop ;9
nop ;9
; 0000 0199 nop ;10
nop ;10
; 0000 019A ;nop ;11
;nop ;11
; 0000 019B cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 019C SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 019D     inc r19 ;16
    inc r19 ;16
; 0000 019E     out PORTC,r19 ;1-8
    out PORTC,r19 ;1-8
; 0000 019F nop ;2
nop ;2
; 0000 01A0 nop ;3
nop ;3
; 0000 01A1 nop ;4
nop ;4
; 0000 01A2 nop ;5
nop ;5
; 0000 01A3 nop ;6
nop ;6
; 0000 01A4 nop ;7
nop ;7
; 0000 01A5 nop ;8
nop ;8
; 0000 01A6 nop ;9
nop ;9
; 0000 01A7 nop ;10
nop ;10
; 0000 01A8 ;nop ;11
;nop ;11
; 0000 01A9 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 01AA SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 01AB     inc r19 ;16
    inc r19 ;16
; 0000 01AC     out PORTC,r19 ;1-9
    out PORTC,r19 ;1-9
; 0000 01AD nop ;2
nop ;2
; 0000 01AE nop ;3
nop ;3
; 0000 01AF nop ;4
nop ;4
; 0000 01B0 nop ;5
nop ;5
; 0000 01B1 nop ;6
nop ;6
; 0000 01B2 nop ;7
nop ;7
; 0000 01B3 nop ;8
nop ;8
; 0000 01B4 nop ;9
nop ;9
; 0000 01B5 nop ;10
nop ;10
; 0000 01B6 ;nop ;11
;nop ;11
; 0000 01B7 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 01B8 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 01B9     inc r19 ;16
    inc r19 ;16
; 0000 01BA      out PORTC,r19 ;1-10
     out PORTC,r19 ;1-10
; 0000 01BB nop ;2
nop ;2
; 0000 01BC nop ;3
nop ;3
; 0000 01BD nop ;4
nop ;4
; 0000 01BE nop ;5
nop ;5
; 0000 01BF nop ;6
nop ;6
; 0000 01C0 nop ;7
nop ;7
; 0000 01C1 nop ;8
nop ;8
; 0000 01C2 nop ;9
nop ;9
; 0000 01C3 nop ;10
nop ;10
; 0000 01C4 ;nop ;11
;nop ;11
; 0000 01C5 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 01C6 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 01C7     inc r19 ;16
    inc r19 ;16
; 0000 01C8      out PORTC,r19 ;1-11
     out PORTC,r19 ;1-11
; 0000 01C9 nop ;2
nop ;2
; 0000 01CA nop ;3
nop ;3
; 0000 01CB nop ;4
nop ;4
; 0000 01CC nop ;5
nop ;5
; 0000 01CD nop ;6
nop ;6
; 0000 01CE nop ;7
nop ;7
; 0000 01CF nop ;8
nop ;8
; 0000 01D0 nop ;9
nop ;9
; 0000 01D1 nop ;10
nop ;10
; 0000 01D2 nop ;11
nop ;11
; 0000 01D3 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 01D4 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 01D5     inc r19 ;16
    inc r19 ;16
; 0000 01D6      out PORTC,r19 ;1-12
     out PORTC,r19 ;1-12
; 0000 01D7 nop ;2
nop ;2
; 0000 01D8 nop ;3
nop ;3
; 0000 01D9 nop ;4
nop ;4
; 0000 01DA nop ;5
nop ;5
; 0000 01DB nop ;6
nop ;6
; 0000 01DC nop ;7
nop ;7
; 0000 01DD nop ;8
nop ;8
; 0000 01DE nop ;9
nop ;9
; 0000 01DF nop ;10
nop ;10
; 0000 01E0 nop ;11
nop ;11
; 0000 01E1 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 01E2 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 01E3     inc r19 ;16
    inc r19 ;16
; 0000 01E4      out PORTC,r19 ;1-13
     out PORTC,r19 ;1-13
; 0000 01E5 nop ;2
nop ;2
; 0000 01E6 nop ;3
nop ;3
; 0000 01E7 nop ;4
nop ;4
; 0000 01E8 nop ;5
nop ;5
; 0000 01E9 nop ;6
nop ;6
; 0000 01EA nop ;7
nop ;7
; 0000 01EB nop ;8
nop ;8
; 0000 01EC nop ;9
nop ;9
; 0000 01ED nop ;10
nop ;10
; 0000 01EE nop ;11
nop ;11
; 0000 01EF cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 01F0 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 01F1     inc r19 ;16
    inc r19 ;16
; 0000 01F2      out PORTC,r19 ;1-14
     out PORTC,r19 ;1-14
; 0000 01F3 nop ;2
nop ;2
; 0000 01F4 nop ;3
nop ;3
; 0000 01F5 nop ;4
nop ;4
; 0000 01F6 nop ;5
nop ;5
; 0000 01F7 nop ;6
nop ;6
; 0000 01F8 nop ;7
nop ;7
; 0000 01F9 nop ;8
nop ;8
; 0000 01FA nop ;9
nop ;9
; 0000 01FB nop ;10
nop ;10
; 0000 01FC nop ;11
nop ;11
; 0000 01FD cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 01FE SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 01FF     inc r19 ;16
    inc r19 ;16
; 0000 0200      out PORTC,r19 ;1-15
     out PORTC,r19 ;1-15
; 0000 0201 nop ;2
nop ;2
; 0000 0202 nop ;3
nop ;3
; 0000 0203 nop ;4
nop ;4
; 0000 0204 nop ;5
nop ;5
; 0000 0205 nop ;6
nop ;6
; 0000 0206 nop ;7
nop ;7
; 0000 0207 nop ;8
nop ;8
; 0000 0208 nop ;9
nop ;9
; 0000 0209 nop ;10
nop ;10
; 0000 020A nop ;11
nop ;11
; 0000 020B cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 020C SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 020D     inc r19 ;16
    inc r19 ;16
; 0000 020E     out PORTC,r19 ;1-16
    out PORTC,r19 ;1-16
; 0000 020F nop ;2
nop ;2
; 0000 0210 nop ;3
nop ;3
; 0000 0211 nop ;4
nop ;4
; 0000 0212 nop ;5
nop ;5
; 0000 0213 nop ;6
nop ;6
; 0000 0214 nop ;7
nop ;7
; 0000 0215 nop ;8
nop ;8
; 0000 0216 nop ;9
nop ;9
; 0000 0217 nop ;10
nop ;10
; 0000 0218 nop ;11
nop ;11
; 0000 0219 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 021A SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 021B     inc r19 ;16
    inc r19 ;16
; 0000 021C     out PORTC,r19 ;1-17
    out PORTC,r19 ;1-17
; 0000 021D nop ;2
nop ;2
; 0000 021E nop ;3
nop ;3
; 0000 021F nop ;4
nop ;4
; 0000 0220 nop ;5
nop ;5
; 0000 0221 nop ;6
nop ;6
; 0000 0222 nop ;7
nop ;7
; 0000 0223 nop ;8
nop ;8
; 0000 0224 nop ;9
nop ;9
; 0000 0225 nop ;10
nop ;10
; 0000 0226 nop ;11
nop ;11
; 0000 0227 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0228 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0229     inc r19 ;16
    inc r19 ;16
; 0000 022A      out PORTC,r19 ;1-18
     out PORTC,r19 ;1-18
; 0000 022B nop ;2
nop ;2
; 0000 022C nop ;3
nop ;3
; 0000 022D nop ;4
nop ;4
; 0000 022E nop ;5
nop ;5
; 0000 022F nop ;6
nop ;6
; 0000 0230 nop ;7
nop ;7
; 0000 0231 nop ;8
nop ;8
; 0000 0232 nop ;9
nop ;9
; 0000 0233 nop ;10
nop ;10
; 0000 0234 nop ;11
nop ;11
; 0000 0235 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0236 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0237     inc r19 ;16
    inc r19 ;16
; 0000 0238      out PORTC,r19 ;1-19
     out PORTC,r19 ;1-19
; 0000 0239 nop ;2
nop ;2
; 0000 023A nop ;3
nop ;3
; 0000 023B nop ;4
nop ;4
; 0000 023C nop ;5
nop ;5
; 0000 023D nop ;6
nop ;6
; 0000 023E nop ;7
nop ;7
; 0000 023F nop ;8
nop ;8
; 0000 0240 nop ;9
nop ;9
; 0000 0241 nop ;10
nop ;10
; 0000 0242 nop ;11
nop ;11
; 0000 0243 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0244 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0245     inc r19 ;16
    inc r19 ;16
; 0000 0246      out PORTC,r19 ;1-20
     out PORTC,r19 ;1-20
; 0000 0247 nop ;2
nop ;2
; 0000 0248 nop ;3
nop ;3
; 0000 0249 nop ;4
nop ;4
; 0000 024A nop ;5
nop ;5
; 0000 024B nop ;6
nop ;6
; 0000 024C nop ;7
nop ;7
; 0000 024D nop ;8
nop ;8
; 0000 024E nop ;9
nop ;9
; 0000 024F nop ;10
nop ;10
; 0000 0250 nop ;11
nop ;11
; 0000 0251 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0252 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0253     inc r19 ;16
    inc r19 ;16
; 0000 0254      out PORTC,r19 ;1-21
     out PORTC,r19 ;1-21
; 0000 0255 nop ;2
nop ;2
; 0000 0256 nop ;3
nop ;3
; 0000 0257 nop ;4
nop ;4
; 0000 0258 nop ;5
nop ;5
; 0000 0259 nop ;6
nop ;6
; 0000 025A nop ;7
nop ;7
; 0000 025B nop ;8
nop ;8
; 0000 025C nop ;9
nop ;9
; 0000 025D nop ;10
nop ;10
; 0000 025E nop ;11
nop ;11
; 0000 025F cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0260 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0261     inc r19 ;16
    inc r19 ;16
; 0000 0262      out PORTC,r19 ;1-22
     out PORTC,r19 ;1-22
; 0000 0263 nop ;2
nop ;2
; 0000 0264 nop ;3
nop ;3
; 0000 0265 nop ;4
nop ;4
; 0000 0266 nop ;5
nop ;5
; 0000 0267 nop ;6
nop ;6
; 0000 0268 nop ;7
nop ;7
; 0000 0269 nop ;8
nop ;8
; 0000 026A nop ;9
nop ;9
; 0000 026B nop ;10
nop ;10
; 0000 026C nop ;11
nop ;11
; 0000 026D cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 026E SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 026F     inc r19 ;16
    inc r19 ;16
; 0000 0270     out PORTC,r19 ;1-23
    out PORTC,r19 ;1-23
; 0000 0271 nop ;2
nop ;2
; 0000 0272 nop ;3
nop ;3
; 0000 0273 nop ;4
nop ;4
; 0000 0274 nop ;5
nop ;5
; 0000 0275 nop ;6
nop ;6
; 0000 0276 nop ;7
nop ;7
; 0000 0277 nop ;8
nop ;8
; 0000 0278 nop ;9
nop ;9
; 0000 0279 nop ;10
nop ;10
; 0000 027A nop ;11
nop ;11
; 0000 027B cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 027C SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 027D     inc r19 ;16
    inc r19 ;16
; 0000 027E      out PORTC,r19 ;1-24
     out PORTC,r19 ;1-24
; 0000 027F nop ;2
nop ;2
; 0000 0280 nop ;3
nop ;3
; 0000 0281 nop ;4
nop ;4
; 0000 0282 nop ;5
nop ;5
; 0000 0283 nop ;6
nop ;6
; 0000 0284 nop ;7
nop ;7
; 0000 0285 nop ;8
nop ;8
; 0000 0286 nop ;9
nop ;9
; 0000 0287 nop ;10
nop ;10
; 0000 0288 nop ;11
nop ;11
; 0000 0289 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 028A SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 028B     inc r19 ;16
    inc r19 ;16
; 0000 028C     out PORTC,r19 ;1-25
    out PORTC,r19 ;1-25
; 0000 028D nop ;2
nop ;2
; 0000 028E nop ;3
nop ;3
; 0000 028F nop ;4
nop ;4
; 0000 0290 nop ;5
nop ;5
; 0000 0291 nop ;6
nop ;6
; 0000 0292 nop ;7
nop ;7
; 0000 0293 nop ;8
nop ;8
; 0000 0294 nop ;9
nop ;9
; 0000 0295 nop ;10
nop ;10
; 0000 0296 nop ;11
nop ;11
; 0000 0297 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0298 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0299     inc r19 ;16
    inc r19 ;16
; 0000 029A     out PORTC,r19 ;1-26
    out PORTC,r19 ;1-26
; 0000 029B nop ;2
nop ;2
; 0000 029C nop ;3
nop ;3
; 0000 029D nop ;4
nop ;4
; 0000 029E nop ;5
nop ;5
; 0000 029F nop ;6
nop ;6
; 0000 02A0 nop ;7
nop ;7
; 0000 02A1 nop ;8
nop ;8
; 0000 02A2 nop ;9
nop ;9
; 0000 02A3 nop ;10
nop ;10
; 0000 02A4 nop ;11
nop ;11
; 0000 02A5 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 02A6 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 02A7     inc r19 ;16
    inc r19 ;16
; 0000 02A8     out PORTC,r19 ;1-27
    out PORTC,r19 ;1-27
; 0000 02A9 nop ;2
nop ;2
; 0000 02AA nop ;3
nop ;3
; 0000 02AB nop ;4
nop ;4
; 0000 02AC nop ;5
nop ;5
; 0000 02AD nop ;6
nop ;6
; 0000 02AE nop ;7
nop ;7
; 0000 02AF nop ;8
nop ;8
; 0000 02B0 nop ;9
nop ;9
; 0000 02B1 nop ;10
nop ;10
; 0000 02B2 nop ;11
nop ;11
; 0000 02B3 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 02B4 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 02B5     inc r19 ;16
    inc r19 ;16
; 0000 02B6     out PORTC,r19 ;1-28
    out PORTC,r19 ;1-28
; 0000 02B7 nop ;2
nop ;2
; 0000 02B8 nop ;3
nop ;3
; 0000 02B9 nop ;4
nop ;4
; 0000 02BA nop ;5
nop ;5
; 0000 02BB nop ;6
nop ;6
; 0000 02BC nop ;7
nop ;7
; 0000 02BD nop ;8
nop ;8
; 0000 02BE nop ;9
nop ;9
; 0000 02BF nop ;10
nop ;10
; 0000 02C0 nop ;11
nop ;11
; 0000 02C1 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 02C2 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 02C3     inc r19 ;16
    inc r19 ;16
; 0000 02C4      out PORTC,r19 ;1-29
     out PORTC,r19 ;1-29
; 0000 02C5 nop ;2
nop ;2
; 0000 02C6 nop ;3
nop ;3
; 0000 02C7 nop ;4
nop ;4
; 0000 02C8 nop ;5
nop ;5
; 0000 02C9 nop ;6
nop ;6
; 0000 02CA nop ;7
nop ;7
; 0000 02CB nop ;8
nop ;8
; 0000 02CC nop ;9
nop ;9
; 0000 02CD nop ;10
nop ;10
; 0000 02CE nop ;11
nop ;11
; 0000 02CF cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 02D0 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 02D1     inc r19 ;16
    inc r19 ;16
; 0000 02D2      out PORTC,r19 ;1-30
     out PORTC,r19 ;1-30
; 0000 02D3 nop ;2
nop ;2
; 0000 02D4 nop ;3
nop ;3
; 0000 02D5 nop ;4
nop ;4
; 0000 02D6 nop ;5
nop ;5
; 0000 02D7 nop ;6
nop ;6
; 0000 02D8 nop ;7
nop ;7
; 0000 02D9 nop ;8
nop ;8
; 0000 02DA nop ;9
nop ;9
; 0000 02DB nop ;10
nop ;10
; 0000 02DC nop ;11
nop ;11
; 0000 02DD cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 02DE SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 02DF     inc r19 ;16
    inc r19 ;16
; 0000 02E0      out PORTC,r19 ;1-31
     out PORTC,r19 ;1-31
; 0000 02E1 nop ;2
nop ;2
; 0000 02E2 nop ;3
nop ;3
; 0000 02E3 nop ;4
nop ;4
; 0000 02E4 nop ;5
nop ;5
; 0000 02E5 nop ;6
nop ;6
; 0000 02E6 nop ;7
nop ;7
; 0000 02E7 nop ;8
nop ;8
; 0000 02E8 nop ;9
nop ;9
; 0000 02E9 nop ;10
nop ;10
; 0000 02EA nop ;11
nop ;11
; 0000 02EB cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 02EC SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 02ED     inc r19 ;16
    inc r19 ;16
; 0000 02EE      out PORTC,r19 ;1-32
     out PORTC,r19 ;1-32
; 0000 02EF nop ;2
nop ;2
; 0000 02F0 nop ;3
nop ;3
; 0000 02F1 nop ;4
nop ;4
; 0000 02F2 nop ;5
nop ;5
; 0000 02F3 nop ;6
nop ;6
; 0000 02F4 nop ;7
nop ;7
; 0000 02F5 nop ;8
nop ;8
; 0000 02F6 nop ;9
nop ;9
; 0000 02F7 nop ;10
nop ;10
; 0000 02F8 nop ;11
nop ;11
; 0000 02F9 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 02FA SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 02FB     inc r19 ;16
    inc r19 ;16
; 0000 02FC     out PORTC,r19 ;1-33
    out PORTC,r19 ;1-33
; 0000 02FD nop ;2
nop ;2
; 0000 02FE nop ;3
nop ;3
; 0000 02FF nop ;4
nop ;4
; 0000 0300 nop ;5
nop ;5
; 0000 0301 nop ;6
nop ;6
; 0000 0302 nop ;7
nop ;7
; 0000 0303 nop ;8
nop ;8
; 0000 0304 nop ;9
nop ;9
; 0000 0305 nop ;10
nop ;10
; 0000 0306 nop ;11
nop ;11
; 0000 0307 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0308 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0309     inc r19 ;16
    inc r19 ;16
; 0000 030A      out PORTC,r19 ;1-34
     out PORTC,r19 ;1-34
; 0000 030B nop ;2
nop ;2
; 0000 030C nop ;3
nop ;3
; 0000 030D nop ;4
nop ;4
; 0000 030E nop ;5
nop ;5
; 0000 030F nop ;6
nop ;6
; 0000 0310 nop ;7
nop ;7
; 0000 0311 nop ;8
nop ;8
; 0000 0312 nop ;9
nop ;9
; 0000 0313 nop ;10
nop ;10
; 0000 0314 nop ;11
nop ;11
; 0000 0315 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0316 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0317     inc r19 ;16
    inc r19 ;16
; 0000 0318      out PORTC,r19 ;1-35
     out PORTC,r19 ;1-35
; 0000 0319 nop ;2
nop ;2
; 0000 031A nop ;3
nop ;3
; 0000 031B nop ;4
nop ;4
; 0000 031C nop ;5
nop ;5
; 0000 031D nop ;6
nop ;6
; 0000 031E nop ;7
nop ;7
; 0000 031F nop ;8
nop ;8
; 0000 0320 nop ;9
nop ;9
; 0000 0321 nop ;10
nop ;10
; 0000 0322 nop ;11
nop ;11
; 0000 0323 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0324 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0325     inc r19 ;16
    inc r19 ;16
; 0000 0326      out PORTC,r19 ;1-36
     out PORTC,r19 ;1-36
; 0000 0327 nop ;2
nop ;2
; 0000 0328 nop ;3
nop ;3
; 0000 0329 nop ;4
nop ;4
; 0000 032A nop ;5
nop ;5
; 0000 032B nop ;6
nop ;6
; 0000 032C nop ;7
nop ;7
; 0000 032D nop ;8
nop ;8
; 0000 032E nop ;9
nop ;9
; 0000 032F nop ;10
nop ;10
; 0000 0330 nop ;11
nop ;11
; 0000 0331 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0332 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0333     inc r19 ;16
    inc r19 ;16
; 0000 0334      out PORTC,r19 ;1-37
     out PORTC,r19 ;1-37
; 0000 0335 nop ;2
nop ;2
; 0000 0336 nop ;3
nop ;3
; 0000 0337 nop ;4
nop ;4
; 0000 0338 nop ;5
nop ;5
; 0000 0339 nop ;6
nop ;6
; 0000 033A nop ;7
nop ;7
; 0000 033B nop ;8
nop ;8
; 0000 033C nop ;9
nop ;9
; 0000 033D nop ;10
nop ;10
; 0000 033E nop ;11
nop ;11
; 0000 033F cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0340 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0341     inc r19 ;16
    inc r19 ;16
; 0000 0342      out PORTC,r19 ;1-38
     out PORTC,r19 ;1-38
; 0000 0343 nop ;2
nop ;2
; 0000 0344 nop ;3
nop ;3
; 0000 0345 nop ;4
nop ;4
; 0000 0346 nop ;5
nop ;5
; 0000 0347 nop ;6
nop ;6
; 0000 0348 nop ;7
nop ;7
; 0000 0349 nop ;8
nop ;8
; 0000 034A nop ;9
nop ;9
; 0000 034B nop ;10
nop ;10
; 0000 034C nop ;11
nop ;11
; 0000 034D cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 034E SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 034F     inc r19 ;16
    inc r19 ;16
; 0000 0350      out PORTC,r19 ;1-39
     out PORTC,r19 ;1-39
; 0000 0351 nop ;2
nop ;2
; 0000 0352 nop ;3
nop ;3
; 0000 0353 nop ;4
nop ;4
; 0000 0354 nop ;5
nop ;5
; 0000 0355 nop ;6
nop ;6
; 0000 0356 nop ;7
nop ;7
; 0000 0357 nop ;8
nop ;8
; 0000 0358 nop ;9
nop ;9
; 0000 0359 nop ;10
nop ;10
; 0000 035A nop ;11
nop ;11
; 0000 035B cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 035C SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 035D     inc r19 ;16
    inc r19 ;16
; 0000 035E      out PORTC,r19 ;1-40
     out PORTC,r19 ;1-40
; 0000 035F nop ;2
nop ;2
; 0000 0360 nop ;3
nop ;3
; 0000 0361 nop ;4
nop ;4
; 0000 0362 nop ;5
nop ;5
; 0000 0363 nop ;6
nop ;6
; 0000 0364 nop ;7
nop ;7
; 0000 0365 nop ;8
nop ;8
; 0000 0366 nop ;9
nop ;9
; 0000 0367 nop ;10
nop ;10
; 0000 0368 nop ;11
nop ;11
; 0000 0369 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 036A SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 036B     inc r19 ;16
    inc r19 ;16
; 0000 036C      out PORTC,r19 ;1-41
     out PORTC,r19 ;1-41
; 0000 036D nop ;2
nop ;2
; 0000 036E nop ;3
nop ;3
; 0000 036F nop ;4
nop ;4
; 0000 0370 nop ;5
nop ;5
; 0000 0371 nop ;6
nop ;6
; 0000 0372 nop ;7
nop ;7
; 0000 0373 nop ;8
nop ;8
; 0000 0374 nop ;9
nop ;9
; 0000 0375 nop ;10
nop ;10
; 0000 0376 nop ;11
nop ;11
; 0000 0377 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0378 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0379     inc r19 ;16
    inc r19 ;16
; 0000 037A      out PORTC,r19 ;1-42
     out PORTC,r19 ;1-42
; 0000 037B nop ;2
nop ;2
; 0000 037C nop ;3
nop ;3
; 0000 037D nop ;4
nop ;4
; 0000 037E nop ;5
nop ;5
; 0000 037F nop ;6
nop ;6
; 0000 0380 nop ;7
nop ;7
; 0000 0381 nop ;8
nop ;8
; 0000 0382 nop ;9
nop ;9
; 0000 0383 nop ;10
nop ;10
; 0000 0384 nop ;11
nop ;11
; 0000 0385 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0386 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0387     inc r19 ;16
    inc r19 ;16
; 0000 0388      out PORTC,r19 ;1-43
     out PORTC,r19 ;1-43
; 0000 0389 nop ;2
nop ;2
; 0000 038A nop ;3
nop ;3
; 0000 038B nop ;4
nop ;4
; 0000 038C nop ;5
nop ;5
; 0000 038D nop ;6
nop ;6
; 0000 038E nop ;7
nop ;7
; 0000 038F nop ;8
nop ;8
; 0000 0390 nop ;9
nop ;9
; 0000 0391 nop ;10
nop ;10
; 0000 0392 nop ;11
nop ;11
; 0000 0393 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0394 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0395     inc r19 ;16
    inc r19 ;16
; 0000 0396      out PORTC,r19 ;1-44
     out PORTC,r19 ;1-44
; 0000 0397 nop ;2
nop ;2
; 0000 0398 nop ;3
nop ;3
; 0000 0399 nop ;4
nop ;4
; 0000 039A nop ;5
nop ;5
; 0000 039B nop ;6
nop ;6
; 0000 039C nop ;7
nop ;7
; 0000 039D nop ;8
nop ;8
; 0000 039E nop ;9
nop ;9
; 0000 039F nop ;10
nop ;10
; 0000 03A0 nop ;11
nop ;11
; 0000 03A1 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 03A2 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 03A3     inc r19 ;16
    inc r19 ;16
; 0000 03A4      out PORTC,r19 ;1-45
     out PORTC,r19 ;1-45
; 0000 03A5 nop ;2
nop ;2
; 0000 03A6 nop ;3
nop ;3
; 0000 03A7 nop ;4
nop ;4
; 0000 03A8 nop ;5
nop ;5
; 0000 03A9 nop ;6
nop ;6
; 0000 03AA nop ;7
nop ;7
; 0000 03AB nop ;8
nop ;8
; 0000 03AC nop ;9
nop ;9
; 0000 03AD nop ;10
nop ;10
; 0000 03AE nop ;11
nop ;11
; 0000 03AF cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 03B0 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 03B1     inc r19 ;16
    inc r19 ;16
; 0000 03B2      out PORTC,r19 ;1-46
     out PORTC,r19 ;1-46
; 0000 03B3 nop ;2
nop ;2
; 0000 03B4 nop ;3
nop ;3
; 0000 03B5 nop ;4
nop ;4
; 0000 03B6 nop ;5
nop ;5
; 0000 03B7 nop ;6
nop ;6
; 0000 03B8 nop ;7
nop ;7
; 0000 03B9 nop ;8
nop ;8
; 0000 03BA nop ;9
nop ;9
; 0000 03BB nop ;10
nop ;10
; 0000 03BC nop ;11
nop ;11
; 0000 03BD cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 03BE SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 03BF     inc r19 ;16
    inc r19 ;16
; 0000 03C0     out PORTC,r19 ;1-47
    out PORTC,r19 ;1-47
; 0000 03C1 nop ;2
nop ;2
; 0000 03C2 nop ;3
nop ;3
; 0000 03C3 nop ;4
nop ;4
; 0000 03C4 nop ;5
nop ;5
; 0000 03C5 nop ;6
nop ;6
; 0000 03C6 nop ;7
nop ;7
; 0000 03C7 nop ;8
nop ;8
; 0000 03C8 nop ;9
nop ;9
; 0000 03C9 nop ;10
nop ;10
; 0000 03CA nop ;11
nop ;11
; 0000 03CB cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 03CC SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 03CD     inc r19 ;16
    inc r19 ;16
; 0000 03CE     out PORTC,r19 ;1-48
    out PORTC,r19 ;1-48
; 0000 03CF nop ;2
nop ;2
; 0000 03D0 nop ;3
nop ;3
; 0000 03D1 nop ;4
nop ;4
; 0000 03D2 nop ;5
nop ;5
; 0000 03D3 nop ;6
nop ;6
; 0000 03D4 nop ;7
nop ;7
; 0000 03D5 nop ;8
nop ;8
; 0000 03D6 nop ;9
nop ;9
; 0000 03D7 nop ;10
nop ;10
; 0000 03D8 nop ;11
nop ;11
; 0000 03D9 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 03DA SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 03DB nop ;16
nop ;16
; 0000 03DC nop ;1
nop ;1
; 0000 03DD nop ;2
nop ;2
; 0000 03DE nop ;3
nop ;3
; 0000 03DF nop ;4
nop ;4
; 0000 03E0 nop ;5
nop ;5
; 0000 03E1 nop ;6
nop ;6
; 0000 03E2 nop ;7
nop ;7
; 0000 03E3 nop ;8
nop ;8
; 0000 03E4 nop ;9
nop ;9
; 0000 03E5 nop ;10
nop ;10
; 0000 03E6 nop ;11
nop ;11
; 0000 03E7 nop ;12
nop ;12
; 0000 03E8 nop ;13
nop ;13
; 0000 03E9 nop ;14
nop ;14
; 0000 03EA nop ;15
nop ;15
; 0000 03EB nop ;15
nop ;15
; 0000 03EC cbi  PORTB,3;16-17  Blank =0
cbi  PORTB,3;16-17  Blank =0
; 0000 03ED     ldi r19,15 ;18  ""
    ldi r19,15 ;18  ""
; 0000 03EE     //clr r19 ;18  " 128"
    //clr r19 ;18  " 128"
; 0000 03EF     out PORTC,r19 ;19
    out PORTC,r19 ;19
; 0000 03F0 

; 0000 03F1 #endasm
; 0000 03F2 goto L2;
	RJMP _0x15
; 0000 03F3   L480:
_0x14:
; 0000 03F4 
; 0000 03F5  #asm
; 0000 03F6  nop;
 nop;
; 0000 03F7  nop;
 nop;
; 0000 03F8  nop;
 nop;
; 0000 03F9  nop;
 nop;
; 0000 03FA  nop;
 nop;
; 0000 03FB  nop;
 nop;
; 0000 03FC  nop;
 nop;
; 0000 03FD  nop;
 nop;
; 0000 03FE  nop;
 nop;
; 0000 03FF  nop;
 nop;
; 0000 0400  nop;
 nop;
; 0000 0401  nop;
 nop;
; 0000 0402  nop;
 nop;
; 0000 0403  nop;
 nop;
; 0000 0404  nop;
 nop;
; 0000 0405   nop; 0
  nop; 0
; 0000 0406  nop;
 nop;
; 0000 0407  nop;
 nop;
; 0000 0408  nop;
 nop;
; 0000 0409  nop;
 nop;
; 0000 040A  nop;
 nop;
; 0000 040B  nop;
 nop;
; 0000 040C  nop;
 nop;
; 0000 040D  nop;
 nop;
; 0000 040E  nop;
 nop;
; 0000 040F  nop;
 nop;
; 0000 0410  nop;
 nop;
; 0000 0411  nop;
 nop;
; 0000 0412  nop;
 nop;
; 0000 0413  nop;
 nop;
; 0000 0414  NOP;
 NOP;
; 0000 0415   NOP; 1
  NOP; 1
; 0000 0416  nop;
 nop;
; 0000 0417  nop;
 nop;
; 0000 0418  nop;
 nop;
; 0000 0419  nop;
 nop;
; 0000 041A  nop;
 nop;
; 0000 041B  nop;
 nop;
; 0000 041C  nop;
 nop;
; 0000 041D  nop;
 nop;
; 0000 041E  nop;
 nop;
; 0000 041F  nop;
 nop;
; 0000 0420  nop;
 nop;
; 0000 0421  nop;
 nop;
; 0000 0422  nop;
 nop;
; 0000 0423  nop;
 nop;
; 0000 0424  nop;
 nop;
; 0000 0425   nop; 2
  nop; 2
; 0000 0426  nop;
 nop;
; 0000 0427  nop;
 nop;
; 0000 0428  nop;
 nop;
; 0000 0429  nop;
 nop;
; 0000 042A  nop;
 nop;
; 0000 042B  nop;
 nop;
; 0000 042C  nop;
 nop;
; 0000 042D  nop;
 nop;
; 0000 042E  nop;
 nop;
; 0000 042F  nop;
 nop;
; 0000 0430  nop;
 nop;
; 0000 0431  nop;
 nop;
; 0000 0432  nop;
 nop;
; 0000 0433  nop;
 nop;
; 0000 0434  NOP;
 NOP;
; 0000 0435   NOP;3
  NOP;3
; 0000 0436  nop;
 nop;
; 0000 0437  nop;
 nop;
; 0000 0438  nop;
 nop;
; 0000 0439  nop;
 nop;
; 0000 043A  nop;
 nop;
; 0000 043B  nop;
 nop;
; 0000 043C  nop;
 nop;
; 0000 043D  nop;
 nop;
; 0000 043E  nop;
 nop;
; 0000 043F  nop;
 nop;
; 0000 0440  nop;
 nop;
; 0000 0441  nop;
 nop;
; 0000 0442  nop;
 nop;
; 0000 0443  nop;
 nop;
; 0000 0444  NOP;
 NOP;
; 0000 0445   NOP;4
  NOP;4
; 0000 0446  nop;
 nop;
; 0000 0447  nop;
 nop;
; 0000 0448  nop;
 nop;
; 0000 0449  nop;
 nop;
; 0000 044A  nop;
 nop;
; 0000 044B  nop;
 nop;
; 0000 044C  nop;
 nop;
; 0000 044D  nop;
 nop;
; 0000 044E  nop;
 nop;
; 0000 044F  nop;
 nop;
; 0000 0450  nop;
 nop;
; 0000 0451  nop;
 nop;
; 0000 0452  nop;
 nop;
; 0000 0453  nop;
 nop;
; 0000 0454  NOP;
 NOP;
; 0000 0455   NOP;5
  NOP;5
; 0000 0456  nop;
 nop;
; 0000 0457  nop;
 nop;
; 0000 0458  nop;
 nop;
; 0000 0459  nop;
 nop;
; 0000 045A  nop;
 nop;
; 0000 045B 

; 0000 045C 

; 0000 045D     out PORTC,r19 ;1-0
    out PORTC,r19 ;1-0
; 0000 045E 

; 0000 045F nop ;2
nop ;2
; 0000 0460 nop ;3
nop ;3
; 0000 0461 nop ;4
nop ;4
; 0000 0462 nop ;5
nop ;5
; 0000 0463 nop ;6
nop ;6
; 0000 0464 nop ;7
nop ;7
; 0000 0465 nop ;8
nop ;8
; 0000 0466 nop ;9
nop ;9
; 0000 0467 cbi PORTB,4 ;10-11 Strob ON
cbi PORTB,4 ;10-11 Strob ON
; 0000 0468 sbi PORTB,3 ;14-15 Blank 1
sbi PORTB,3 ;14-15 Blank 1
; 0000 0469 SBI PORTB,4 ;12-13 Strob OFF
SBI PORTB,4 ;12-13 Strob OFF
; 0000 046A 

; 0000 046B     inc r19 ;16
    inc r19 ;16
; 0000 046C 

; 0000 046D     out PORTC,r19 ;1-1
    out PORTC,r19 ;1-1
; 0000 046E 

; 0000 046F nop ;2
nop ;2
; 0000 0470 nop ;3
nop ;3
; 0000 0471 nop ;4
nop ;4
; 0000 0472 nop ;5
nop ;5
; 0000 0473 nop ;6
nop ;6
; 0000 0474 nop ;7
nop ;7
; 0000 0475 nop ;8
nop ;8
; 0000 0476 nop ;9
nop ;9
; 0000 0477 nop ;10
nop ;10
; 0000 0478 nop ;11
nop ;11
; 0000 0479 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 047A SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 047B     inc r19 ;16
    inc r19 ;16
; 0000 047C     out PORTC,r19 ;1-2
    out PORTC,r19 ;1-2
; 0000 047D nop ;2
nop ;2
; 0000 047E nop ;3
nop ;3
; 0000 047F nop ;4
nop ;4
; 0000 0480 nop ;5
nop ;5
; 0000 0481 nop ;6
nop ;6
; 0000 0482 nop ;7
nop ;7
; 0000 0483 nop ;8
nop ;8
; 0000 0484 nop ;9
nop ;9
; 0000 0485 nop ;10
nop ;10
; 0000 0486 nop ;11
nop ;11
; 0000 0487 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0488 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0489     inc r19 ;16
    inc r19 ;16
; 0000 048A     out PORTC,r19 ;1-3
    out PORTC,r19 ;1-3
; 0000 048B nop ;2
nop ;2
; 0000 048C nop ;3
nop ;3
; 0000 048D nop ;4
nop ;4
; 0000 048E nop ;5
nop ;5
; 0000 048F nop ;6
nop ;6
; 0000 0490 nop ;7
nop ;7
; 0000 0491 nop ;8
nop ;8
; 0000 0492 nop ;9
nop ;9
; 0000 0493 nop ;10
nop ;10
; 0000 0494 nop ;11
nop ;11
; 0000 0495 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0496 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0497     inc r19 ;16
    inc r19 ;16
; 0000 0498     out PORTC,r19 ;1-4
    out PORTC,r19 ;1-4
; 0000 0499 nop ;2
nop ;2
; 0000 049A nop ;3
nop ;3
; 0000 049B nop ;4
nop ;4
; 0000 049C nop ;5
nop ;5
; 0000 049D nop ;6
nop ;6
; 0000 049E nop ;7
nop ;7
; 0000 049F nop ;8
nop ;8
; 0000 04A0 nop ;9
nop ;9
; 0000 04A1 nop ;10
nop ;10
; 0000 04A2 nop ;11
nop ;11
; 0000 04A3 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 04A4 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 04A5     inc r19 ;16
    inc r19 ;16
; 0000 04A6     out PORTC,r19 ;1-5
    out PORTC,r19 ;1-5
; 0000 04A7 nop ;2
nop ;2
; 0000 04A8 nop ;3
nop ;3
; 0000 04A9 nop ;4
nop ;4
; 0000 04AA nop ;5
nop ;5
; 0000 04AB nop ;6
nop ;6
; 0000 04AC nop ;7
nop ;7
; 0000 04AD nop ;8
nop ;8
; 0000 04AE nop ;9
nop ;9
; 0000 04AF nop ;10
nop ;10
; 0000 04B0 nop ;11
nop ;11
; 0000 04B1 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 04B2 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 04B3     inc r19 ;16
    inc r19 ;16
; 0000 04B4      out PORTC,r19 ;1-6
     out PORTC,r19 ;1-6
; 0000 04B5 nop ;2
nop ;2
; 0000 04B6 nop ;3
nop ;3
; 0000 04B7 nop ;4
nop ;4
; 0000 04B8 nop ;5
nop ;5
; 0000 04B9 nop ;6
nop ;6
; 0000 04BA nop ;7
nop ;7
; 0000 04BB nop ;8
nop ;8
; 0000 04BC nop ;9
nop ;9
; 0000 04BD nop ;10
nop ;10
; 0000 04BE nop ;11
nop ;11
; 0000 04BF cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 04C0 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 04C1     inc r19 ;16
    inc r19 ;16
; 0000 04C2      out PORTC,r19 ;1-7
     out PORTC,r19 ;1-7
; 0000 04C3 nop ;2
nop ;2
; 0000 04C4 nop ;3
nop ;3
; 0000 04C5 nop ;4
nop ;4
; 0000 04C6 nop ;5
nop ;5
; 0000 04C7 nop ;6
nop ;6
; 0000 04C8 nop ;7
nop ;7
; 0000 04C9 nop ;8
nop ;8
; 0000 04CA nop ;9
nop ;9
; 0000 04CB nop ;10
nop ;10
; 0000 04CC nop ;11
nop ;11
; 0000 04CD cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 04CE SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 04CF     inc r19 ;16
    inc r19 ;16
; 0000 04D0      out PORTC,r19 ;1-8
     out PORTC,r19 ;1-8
; 0000 04D1 nop ;2
nop ;2
; 0000 04D2 nop ;3
nop ;3
; 0000 04D3 nop ;4
nop ;4
; 0000 04D4 nop ;5
nop ;5
; 0000 04D5 nop ;6
nop ;6
; 0000 04D6 nop ;7
nop ;7
; 0000 04D7 nop ;8
nop ;8
; 0000 04D8 nop ;9
nop ;9
; 0000 04D9 nop ;10
nop ;10
; 0000 04DA nop ;11
nop ;11
; 0000 04DB cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 04DC SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 04DD     inc r19 ;16
    inc r19 ;16
; 0000 04DE      out PORTC,r19 ;1-9
     out PORTC,r19 ;1-9
; 0000 04DF nop ;2
nop ;2
; 0000 04E0 nop ;3
nop ;3
; 0000 04E1 nop ;4
nop ;4
; 0000 04E2 nop ;5
nop ;5
; 0000 04E3 nop ;6
nop ;6
; 0000 04E4 nop ;7
nop ;7
; 0000 04E5 nop ;8
nop ;8
; 0000 04E6 nop ;9
nop ;9
; 0000 04E7 nop ;10
nop ;10
; 0000 04E8 nop ;11
nop ;11
; 0000 04E9 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 04EA SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 04EB     inc r19 ;16
    inc r19 ;16
; 0000 04EC     out PORTC,r19 ;1-10
    out PORTC,r19 ;1-10
; 0000 04ED nop ;2
nop ;2
; 0000 04EE nop ;3
nop ;3
; 0000 04EF nop ;4
nop ;4
; 0000 04F0 nop ;5
nop ;5
; 0000 04F1 nop ;6
nop ;6
; 0000 04F2 nop ;7
nop ;7
; 0000 04F3 nop ;8
nop ;8
; 0000 04F4 nop ;9
nop ;9
; 0000 04F5 nop ;10
nop ;10
; 0000 04F6 nop ;11
nop ;11
; 0000 04F7 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 04F8 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 04F9     inc r19 ;16
    inc r19 ;16
; 0000 04FA      out PORTC,r19 ;1-11
     out PORTC,r19 ;1-11
; 0000 04FB nop ;2
nop ;2
; 0000 04FC nop ;3
nop ;3
; 0000 04FD nop ;4
nop ;4
; 0000 04FE nop ;5
nop ;5
; 0000 04FF nop ;6
nop ;6
; 0000 0500 nop ;7
nop ;7
; 0000 0501 nop ;8
nop ;8
; 0000 0502 nop ;9
nop ;9
; 0000 0503 nop ;10
nop ;10
; 0000 0504 nop ;11
nop ;11
; 0000 0505 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0506 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0507     inc r19 ;16
    inc r19 ;16
; 0000 0508      out PORTC,r19 ;1-12
     out PORTC,r19 ;1-12
; 0000 0509 nop ;2
nop ;2
; 0000 050A nop ;3
nop ;3
; 0000 050B nop ;4
nop ;4
; 0000 050C nop ;5
nop ;5
; 0000 050D nop ;6
nop ;6
; 0000 050E nop ;7
nop ;7
; 0000 050F nop ;8
nop ;8
; 0000 0510 nop ;9
nop ;9
; 0000 0511 nop ;10
nop ;10
; 0000 0512 nop ;11
nop ;11
; 0000 0513 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0514 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0515     inc r19 ;16
    inc r19 ;16
; 0000 0516      out PORTC,r19 ;1-13
     out PORTC,r19 ;1-13
; 0000 0517 nop ;2
nop ;2
; 0000 0518 nop ;3
nop ;3
; 0000 0519 nop ;4
nop ;4
; 0000 051A nop ;5
nop ;5
; 0000 051B nop ;6
nop ;6
; 0000 051C nop ;7
nop ;7
; 0000 051D nop ;8
nop ;8
; 0000 051E nop ;9
nop ;9
; 0000 051F nop ;10
nop ;10
; 0000 0520 nop ;11
nop ;11
; 0000 0521 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0522 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0523     inc r19 ;16
    inc r19 ;16
; 0000 0524      out PORTC,r19 ;1-14
     out PORTC,r19 ;1-14
; 0000 0525 nop ;2
nop ;2
; 0000 0526 nop ;3
nop ;3
; 0000 0527 nop ;4
nop ;4
; 0000 0528 nop ;5
nop ;5
; 0000 0529 nop ;6
nop ;6
; 0000 052A nop ;7
nop ;7
; 0000 052B nop ;8
nop ;8
; 0000 052C nop ;9
nop ;9
; 0000 052D nop ;10
nop ;10
; 0000 052E nop ;11
nop ;11
; 0000 052F cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0530 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0531     inc r19 ;16
    inc r19 ;16
; 0000 0532      out PORTC,r19 ;1-15
     out PORTC,r19 ;1-15
; 0000 0533 nop ;2
nop ;2
; 0000 0534 nop ;3
nop ;3
; 0000 0535 nop ;4
nop ;4
; 0000 0536 nop ;5
nop ;5
; 0000 0537 nop ;6
nop ;6
; 0000 0538 nop ;7
nop ;7
; 0000 0539 nop ;8
nop ;8
; 0000 053A nop ;9
nop ;9
; 0000 053B nop ;10
nop ;10
; 0000 053C nop ;11
nop ;11
; 0000 053D cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 053E SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 053F     inc r19 ;16
    inc r19 ;16
; 0000 0540      out PORTC,r19 ;1-16
     out PORTC,r19 ;1-16
; 0000 0541 nop ;2
nop ;2
; 0000 0542 nop ;3
nop ;3
; 0000 0543 nop ;4
nop ;4
; 0000 0544 nop ;5
nop ;5
; 0000 0545 nop ;6
nop ;6
; 0000 0546 nop ;7
nop ;7
; 0000 0547 nop ;8
nop ;8
; 0000 0548 nop ;9
nop ;9
; 0000 0549 nop ;10
nop ;10
; 0000 054A nop ;11
nop ;11
; 0000 054B cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 054C SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 054D     inc r19 ;16
    inc r19 ;16
; 0000 054E      out PORTC,r19 ;1-17
     out PORTC,r19 ;1-17
; 0000 054F nop ;2
nop ;2
; 0000 0550 nop ;3
nop ;3
; 0000 0551 nop ;4
nop ;4
; 0000 0552 nop ;5
nop ;5
; 0000 0553 nop ;6
nop ;6
; 0000 0554 nop ;7
nop ;7
; 0000 0555 nop ;8
nop ;8
; 0000 0556 nop ;9
nop ;9
; 0000 0557 nop ;10
nop ;10
; 0000 0558 nop ;11
nop ;11
; 0000 0559 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 055A SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 055B     inc r19 ;16
    inc r19 ;16
; 0000 055C      out PORTC,r19 ;1-18
     out PORTC,r19 ;1-18
; 0000 055D nop ;2
nop ;2
; 0000 055E nop ;3
nop ;3
; 0000 055F nop ;4
nop ;4
; 0000 0560 nop ;5
nop ;5
; 0000 0561 nop ;6
nop ;6
; 0000 0562 nop ;7
nop ;7
; 0000 0563 nop ;8
nop ;8
; 0000 0564 nop ;9
nop ;9
; 0000 0565 nop ;10
nop ;10
; 0000 0566 nop ;11
nop ;11
; 0000 0567 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0568 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0569     inc r19 ;16
    inc r19 ;16
; 0000 056A      out PORTC,r19 ;1-19
     out PORTC,r19 ;1-19
; 0000 056B nop ;2
nop ;2
; 0000 056C nop ;3
nop ;3
; 0000 056D nop ;4
nop ;4
; 0000 056E nop ;5
nop ;5
; 0000 056F nop ;6
nop ;6
; 0000 0570 nop ;7
nop ;7
; 0000 0571 nop ;8
nop ;8
; 0000 0572 nop ;9
nop ;9
; 0000 0573 nop ;10
nop ;10
; 0000 0574 nop ;11
nop ;11
; 0000 0575 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0576 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0577     inc r19 ;16
    inc r19 ;16
; 0000 0578      out PORTC,r19 ;1-20
     out PORTC,r19 ;1-20
; 0000 0579 nop ;2
nop ;2
; 0000 057A nop ;3
nop ;3
; 0000 057B nop ;4
nop ;4
; 0000 057C nop ;5
nop ;5
; 0000 057D nop ;6
nop ;6
; 0000 057E nop ;7
nop ;7
; 0000 057F nop ;8
nop ;8
; 0000 0580 nop ;9
nop ;9
; 0000 0581 nop ;10
nop ;10
; 0000 0582 nop ;11
nop ;11
; 0000 0583 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0584 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0585     inc r19 ;16
    inc r19 ;16
; 0000 0586      out PORTC,r19 ;1-21
     out PORTC,r19 ;1-21
; 0000 0587 nop ;2
nop ;2
; 0000 0588 nop ;3
nop ;3
; 0000 0589 nop ;4
nop ;4
; 0000 058A nop ;5
nop ;5
; 0000 058B nop ;6
nop ;6
; 0000 058C nop ;7
nop ;7
; 0000 058D nop ;8
nop ;8
; 0000 058E nop ;9
nop ;9
; 0000 058F nop ;10
nop ;10
; 0000 0590 nop ;11
nop ;11
; 0000 0591 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0592 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0593     inc r19 ;16
    inc r19 ;16
; 0000 0594      out PORTC,r19 ;1-22
     out PORTC,r19 ;1-22
; 0000 0595 nop ;2
nop ;2
; 0000 0596 nop ;3
nop ;3
; 0000 0597 nop ;4
nop ;4
; 0000 0598 nop ;5
nop ;5
; 0000 0599 nop ;6
nop ;6
; 0000 059A nop ;7
nop ;7
; 0000 059B nop ;8
nop ;8
; 0000 059C nop ;9
nop ;9
; 0000 059D nop ;10
nop ;10
; 0000 059E nop ;11
nop ;11
; 0000 059F cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 05A0 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 05A1     inc r19 ;16
    inc r19 ;16
; 0000 05A2      out PORTC,r19 ;1-23
     out PORTC,r19 ;1-23
; 0000 05A3 nop ;2
nop ;2
; 0000 05A4 nop ;3
nop ;3
; 0000 05A5 nop ;4
nop ;4
; 0000 05A6 nop ;5
nop ;5
; 0000 05A7 nop ;6
nop ;6
; 0000 05A8 nop ;7
nop ;7
; 0000 05A9 nop ;8
nop ;8
; 0000 05AA nop ;9
nop ;9
; 0000 05AB nop ;10
nop ;10
; 0000 05AC nop ;11
nop ;11
; 0000 05AD cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 05AE SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 05AF     inc r19 ;16
    inc r19 ;16
; 0000 05B0      out PORTC,r19 ;1-24
     out PORTC,r19 ;1-24
; 0000 05B1 nop ;2
nop ;2
; 0000 05B2 nop ;3
nop ;3
; 0000 05B3 nop ;4
nop ;4
; 0000 05B4 nop ;5
nop ;5
; 0000 05B5 nop ;6
nop ;6
; 0000 05B6 nop ;7
nop ;7
; 0000 05B7 nop ;8
nop ;8
; 0000 05B8 nop ;9
nop ;9
; 0000 05B9 nop ;10
nop ;10
; 0000 05BA nop ;11
nop ;11
; 0000 05BB cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 05BC SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 05BD     inc r19 ;16
    inc r19 ;16
; 0000 05BE      out PORTC,r19 ;1-25
     out PORTC,r19 ;1-25
; 0000 05BF nop ;2
nop ;2
; 0000 05C0 nop ;3
nop ;3
; 0000 05C1 nop ;4
nop ;4
; 0000 05C2 nop ;5
nop ;5
; 0000 05C3 nop ;6
nop ;6
; 0000 05C4 nop ;7
nop ;7
; 0000 05C5 nop ;8
nop ;8
; 0000 05C6 nop ;9
nop ;9
; 0000 05C7 nop ;10
nop ;10
; 0000 05C8 nop ;11
nop ;11
; 0000 05C9 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 05CA SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 05CB     inc r19 ;16
    inc r19 ;16
; 0000 05CC      out PORTC,r19 ;1-26
     out PORTC,r19 ;1-26
; 0000 05CD nop ;2
nop ;2
; 0000 05CE nop ;3
nop ;3
; 0000 05CF nop ;4
nop ;4
; 0000 05D0 nop ;5
nop ;5
; 0000 05D1 nop ;6
nop ;6
; 0000 05D2 nop ;7
nop ;7
; 0000 05D3 nop ;8
nop ;8
; 0000 05D4 nop ;9
nop ;9
; 0000 05D5 nop ;10
nop ;10
; 0000 05D6 nop ;11
nop ;11
; 0000 05D7 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 05D8 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 05D9     inc r19 ;16
    inc r19 ;16
; 0000 05DA      out PORTC,r19 ;1-27
     out PORTC,r19 ;1-27
; 0000 05DB nop ;2
nop ;2
; 0000 05DC nop ;3
nop ;3
; 0000 05DD nop ;4
nop ;4
; 0000 05DE nop ;5
nop ;5
; 0000 05DF nop ;6
nop ;6
; 0000 05E0 nop ;7
nop ;7
; 0000 05E1 nop ;8
nop ;8
; 0000 05E2 nop ;9
nop ;9
; 0000 05E3 nop ;10
nop ;10
; 0000 05E4 nop ;11
nop ;11
; 0000 05E5 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 05E6 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 05E7     inc r19 ;16
    inc r19 ;16
; 0000 05E8      out PORTC,r19 ;1-28
     out PORTC,r19 ;1-28
; 0000 05E9 nop ;2
nop ;2
; 0000 05EA nop ;3
nop ;3
; 0000 05EB nop ;4
nop ;4
; 0000 05EC nop ;5
nop ;5
; 0000 05ED nop ;6
nop ;6
; 0000 05EE nop ;7
nop ;7
; 0000 05EF nop ;8
nop ;8
; 0000 05F0 nop ;9
nop ;9
; 0000 05F1 nop ;10
nop ;10
; 0000 05F2 nop ;11
nop ;11
; 0000 05F3 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 05F4 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 05F5     inc r19 ;16
    inc r19 ;16
; 0000 05F6      out PORTC,r19 ;1-29
     out PORTC,r19 ;1-29
; 0000 05F7 nop ;2
nop ;2
; 0000 05F8 nop ;3
nop ;3
; 0000 05F9 nop ;4
nop ;4
; 0000 05FA nop ;5
nop ;5
; 0000 05FB nop ;6
nop ;6
; 0000 05FC nop ;7
nop ;7
; 0000 05FD nop ;8
nop ;8
; 0000 05FE nop ;9
nop ;9
; 0000 05FF nop ;10
nop ;10
; 0000 0600 nop ;11
nop ;11
; 0000 0601 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0602 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0603     inc r19 ;16
    inc r19 ;16
; 0000 0604      out PORTC,r19 ;1-30
     out PORTC,r19 ;1-30
; 0000 0605 nop ;2
nop ;2
; 0000 0606 nop ;3
nop ;3
; 0000 0607 nop ;4
nop ;4
; 0000 0608 nop ;5
nop ;5
; 0000 0609 nop ;6
nop ;6
; 0000 060A nop ;7
nop ;7
; 0000 060B nop ;8
nop ;8
; 0000 060C nop ;9
nop ;9
; 0000 060D nop ;10
nop ;10
; 0000 060E nop ;11
nop ;11
; 0000 060F cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0610 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0611     inc r19 ;16
    inc r19 ;16
; 0000 0612      out PORTC,r19 ;1-31
     out PORTC,r19 ;1-31
; 0000 0613 nop ;2
nop ;2
; 0000 0614 nop ;3
nop ;3
; 0000 0615 nop ;4
nop ;4
; 0000 0616 nop ;5
nop ;5
; 0000 0617 nop ;6
nop ;6
; 0000 0618 nop ;7
nop ;7
; 0000 0619 nop ;8
nop ;8
; 0000 061A nop ;9
nop ;9
; 0000 061B nop ;10
nop ;10
; 0000 061C nop ;11
nop ;11
; 0000 061D cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 061E SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 061F     inc r19 ;16
    inc r19 ;16
; 0000 0620      out PORTC,r19 ;1-32
     out PORTC,r19 ;1-32
; 0000 0621 nop ;2
nop ;2
; 0000 0622 nop ;3
nop ;3
; 0000 0623 nop ;4
nop ;4
; 0000 0624 nop ;5
nop ;5
; 0000 0625 nop ;6
nop ;6
; 0000 0626 nop ;7
nop ;7
; 0000 0627 nop ;8
nop ;8
; 0000 0628 nop ;9
nop ;9
; 0000 0629 nop ;10
nop ;10
; 0000 062A nop ;11
nop ;11
; 0000 062B cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 062C SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 062D     inc r19 ;16
    inc r19 ;16
; 0000 062E      out PORTC,r19 ;1-33
     out PORTC,r19 ;1-33
; 0000 062F nop ;2
nop ;2
; 0000 0630 nop ;3
nop ;3
; 0000 0631 nop ;4
nop ;4
; 0000 0632 nop ;5
nop ;5
; 0000 0633 nop ;6
nop ;6
; 0000 0634 nop ;7
nop ;7
; 0000 0635 nop ;8
nop ;8
; 0000 0636 nop ;9
nop ;9
; 0000 0637 nop ;10
nop ;10
; 0000 0638 nop ;11
nop ;11
; 0000 0639 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 063A SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 063B     inc r19 ;16
    inc r19 ;16
; 0000 063C      out PORTC,r19 ;1-34
     out PORTC,r19 ;1-34
; 0000 063D nop ;2
nop ;2
; 0000 063E nop ;3
nop ;3
; 0000 063F nop ;4
nop ;4
; 0000 0640 nop ;5
nop ;5
; 0000 0641 nop ;6
nop ;6
; 0000 0642 nop ;7
nop ;7
; 0000 0643 nop ;8
nop ;8
; 0000 0644 nop ;9
nop ;9
; 0000 0645 nop ;10
nop ;10
; 0000 0646 nop ;11
nop ;11
; 0000 0647 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0648 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0649     inc r19 ;16
    inc r19 ;16
; 0000 064A      out PORTC,r19 ;1-35
     out PORTC,r19 ;1-35
; 0000 064B nop ;2
nop ;2
; 0000 064C nop ;3
nop ;3
; 0000 064D nop ;4
nop ;4
; 0000 064E nop ;5
nop ;5
; 0000 064F nop ;6
nop ;6
; 0000 0650 nop ;7
nop ;7
; 0000 0651 nop ;8
nop ;8
; 0000 0652 nop ;9
nop ;9
; 0000 0653 nop ;10
nop ;10
; 0000 0654 nop ;11
nop ;11
; 0000 0655 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0656 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0657     inc r19 ;16
    inc r19 ;16
; 0000 0658      out PORTC,r19 ;1-36
     out PORTC,r19 ;1-36
; 0000 0659 nop ;2
nop ;2
; 0000 065A nop ;3
nop ;3
; 0000 065B nop ;4
nop ;4
; 0000 065C nop ;5
nop ;5
; 0000 065D nop ;6
nop ;6
; 0000 065E nop ;7
nop ;7
; 0000 065F nop ;8
nop ;8
; 0000 0660 nop ;9
nop ;9
; 0000 0661 nop ;10
nop ;10
; 0000 0662 nop ;11
nop ;11
; 0000 0663 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0664 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0665     inc r19 ;16
    inc r19 ;16
; 0000 0666      out PORTC,r19 ;1-37
     out PORTC,r19 ;1-37
; 0000 0667 nop ;2
nop ;2
; 0000 0668 nop ;3
nop ;3
; 0000 0669 nop ;4
nop ;4
; 0000 066A nop ;5
nop ;5
; 0000 066B nop ;6
nop ;6
; 0000 066C nop ;7
nop ;7
; 0000 066D nop ;8
nop ;8
; 0000 066E nop ;9
nop ;9
; 0000 066F nop ;10
nop ;10
; 0000 0670 nop ;11
nop ;11
; 0000 0671 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0672 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0673     inc r19 ;16
    inc r19 ;16
; 0000 0674     out PORTC,r19 ;1-38
    out PORTC,r19 ;1-38
; 0000 0675 nop ;2
nop ;2
; 0000 0676 nop ;3
nop ;3
; 0000 0677 nop ;4
nop ;4
; 0000 0678 nop ;5
nop ;5
; 0000 0679 nop ;6
nop ;6
; 0000 067A nop ;7
nop ;7
; 0000 067B nop ;8
nop ;8
; 0000 067C nop ;9
nop ;9
; 0000 067D nop ;10
nop ;10
; 0000 067E nop ;11
nop ;11
; 0000 067F cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0680 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0681     inc r19 ;16
    inc r19 ;16
; 0000 0682      out PORTC,r19 ;1-39
     out PORTC,r19 ;1-39
; 0000 0683 nop ;2
nop ;2
; 0000 0684 nop ;3
nop ;3
; 0000 0685 nop ;4
nop ;4
; 0000 0686 nop ;5
nop ;5
; 0000 0687 nop ;6
nop ;6
; 0000 0688 nop ;7
nop ;7
; 0000 0689 nop ;8
nop ;8
; 0000 068A nop ;9
nop ;9
; 0000 068B nop ;10
nop ;10
; 0000 068C nop ;11
nop ;11
; 0000 068D cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 068E SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 068F     inc r19 ;16
    inc r19 ;16
; 0000 0690      out PORTC,r19 ;1-40
     out PORTC,r19 ;1-40
; 0000 0691 nop ;2
nop ;2
; 0000 0692 nop ;3
nop ;3
; 0000 0693 nop ;4
nop ;4
; 0000 0694 nop ;5
nop ;5
; 0000 0695 nop ;6
nop ;6
; 0000 0696 nop ;7
nop ;7
; 0000 0697 nop ;8
nop ;8
; 0000 0698 nop ;9
nop ;9
; 0000 0699 nop ;10
nop ;10
; 0000 069A nop ;11
nop ;11
; 0000 069B cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 069C SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 069D     inc r19 ;16
    inc r19 ;16
; 0000 069E      out PORTC,r19 ;1-41
     out PORTC,r19 ;1-41
; 0000 069F nop ;2
nop ;2
; 0000 06A0 nop ;3
nop ;3
; 0000 06A1 nop ;4
nop ;4
; 0000 06A2 nop ;5
nop ;5
; 0000 06A3 nop ;6
nop ;6
; 0000 06A4 nop ;7
nop ;7
; 0000 06A5 nop ;8
nop ;8
; 0000 06A6 nop ;9
nop ;9
; 0000 06A7 nop ;10
nop ;10
; 0000 06A8 nop ;11
nop ;11
; 0000 06A9 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 06AA SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 06AB     inc r19 ;16
    inc r19 ;16
; 0000 06AC      out PORTC,r19 ;1-42
     out PORTC,r19 ;1-42
; 0000 06AD nop ;2
nop ;2
; 0000 06AE nop ;3
nop ;3
; 0000 06AF nop ;4
nop ;4
; 0000 06B0 nop ;5
nop ;5
; 0000 06B1 nop ;6
nop ;6
; 0000 06B2 nop ;7
nop ;7
; 0000 06B3 nop ;8
nop ;8
; 0000 06B4 nop ;9
nop ;9
; 0000 06B5 nop ;10
nop ;10
; 0000 06B6 nop ;11
nop ;11
; 0000 06B7 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 06B8 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 06B9     inc r19 ;16
    inc r19 ;16
; 0000 06BA      out PORTC,r19 ;1-43
     out PORTC,r19 ;1-43
; 0000 06BB nop ;2
nop ;2
; 0000 06BC nop ;3
nop ;3
; 0000 06BD nop ;4
nop ;4
; 0000 06BE nop ;5
nop ;5
; 0000 06BF nop ;6
nop ;6
; 0000 06C0 nop ;7
nop ;7
; 0000 06C1 nop ;8
nop ;8
; 0000 06C2 nop ;9
nop ;9
; 0000 06C3 nop ;10
nop ;10
; 0000 06C4 nop ;11
nop ;11
; 0000 06C5 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 06C6 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 06C7     inc r19 ;16
    inc r19 ;16
; 0000 06C8      out PORTC,r19 ;1-44
     out PORTC,r19 ;1-44
; 0000 06C9 nop ;2
nop ;2
; 0000 06CA nop ;3
nop ;3
; 0000 06CB nop ;4
nop ;4
; 0000 06CC nop ;5
nop ;5
; 0000 06CD nop ;6
nop ;6
; 0000 06CE nop ;7
nop ;7
; 0000 06CF nop ;8
nop ;8
; 0000 06D0 nop ;9
nop ;9
; 0000 06D1 nop ;10
nop ;10
; 0000 06D2 nop ;11
nop ;11
; 0000 06D3 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 06D4 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 06D5     inc r19 ;16
    inc r19 ;16
; 0000 06D6      out PORTC,r19 ;1-45
     out PORTC,r19 ;1-45
; 0000 06D7 nop ;2
nop ;2
; 0000 06D8 nop ;3
nop ;3
; 0000 06D9 nop ;4
nop ;4
; 0000 06DA nop ;5
nop ;5
; 0000 06DB nop ;6
nop ;6
; 0000 06DC nop ;7
nop ;7
; 0000 06DD nop ;8
nop ;8
; 0000 06DE nop ;9
nop ;9
; 0000 06DF nop ;10
nop ;10
; 0000 06E0 nop ;11
nop ;11
; 0000 06E1 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 06E2 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 06E3     inc r19 ;16
    inc r19 ;16
; 0000 06E4      out PORTC,r19 ;1-46
     out PORTC,r19 ;1-46
; 0000 06E5 nop ;2
nop ;2
; 0000 06E6 nop ;3
nop ;3
; 0000 06E7 nop ;4
nop ;4
; 0000 06E8 nop ;5
nop ;5
; 0000 06E9 nop ;6
nop ;6
; 0000 06EA nop ;7
nop ;7
; 0000 06EB nop ;8
nop ;8
; 0000 06EC nop ;9
nop ;9
; 0000 06ED nop ;10
nop ;10
; 0000 06EE nop ;11
nop ;11
; 0000 06EF cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 06F0 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 06F1     inc r19 ;16
    inc r19 ;16
; 0000 06F2      out PORTC,r19 ;1-47
     out PORTC,r19 ;1-47
; 0000 06F3 nop ;2
nop ;2
; 0000 06F4 nop ;3
nop ;3
; 0000 06F5 nop ;4
nop ;4
; 0000 06F6 nop ;5
nop ;5
; 0000 06F7 nop ;6
nop ;6
; 0000 06F8 nop ;7
nop ;7
; 0000 06F9 nop ;8
nop ;8
; 0000 06FA nop ;9
nop ;9
; 0000 06FB nop ;10
nop ;10
; 0000 06FC nop ;11
nop ;11
; 0000 06FD cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 06FE SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 06FF     inc r19 ;16
    inc r19 ;16
; 0000 0700      out PORTC,r19 ;1-48
     out PORTC,r19 ;1-48
; 0000 0701 nop ;2
nop ;2
; 0000 0702 nop ;3
nop ;3
; 0000 0703 nop ;4
nop ;4
; 0000 0704 nop ;5
nop ;5
; 0000 0705 nop ;6
nop ;6
; 0000 0706 nop ;7
nop ;7
; 0000 0707 nop ;8
nop ;8
; 0000 0708 nop ;9
nop ;9
; 0000 0709 nop ;10
nop ;10
; 0000 070A nop ;11
nop ;11
; 0000 070B cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 070C SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 070D     inc r19 ;16
    inc r19 ;16
; 0000 070E      out PORTC,r19 ;1-49
     out PORTC,r19 ;1-49
; 0000 070F nop ;2
nop ;2
; 0000 0710 nop ;3
nop ;3
; 0000 0711 nop ;4
nop ;4
; 0000 0712 nop ;5
nop ;5
; 0000 0713 nop ;6
nop ;6
; 0000 0714 nop ;7
nop ;7
; 0000 0715 nop ;8
nop ;8
; 0000 0716 nop ;9
nop ;9
; 0000 0717 nop ;10
nop ;10
; 0000 0718 nop ;11
nop ;11
; 0000 0719 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 071A SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 071B     inc r19 ;16
    inc r19 ;16
; 0000 071C      out PORTC,r19 ;1-50
     out PORTC,r19 ;1-50
; 0000 071D nop ;2
nop ;2
; 0000 071E nop ;3
nop ;3
; 0000 071F nop ;4
nop ;4
; 0000 0720 nop ;5
nop ;5
; 0000 0721 nop ;6
nop ;6
; 0000 0722 nop ;7
nop ;7
; 0000 0723 nop ;8
nop ;8
; 0000 0724 nop ;9
nop ;9
; 0000 0725 nop ;10
nop ;10
; 0000 0726 nop ;11
nop ;11
; 0000 0727 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0728 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0729     inc r19 ;16
    inc r19 ;16
; 0000 072A      out PORTC,r19 ;1-51
     out PORTC,r19 ;1-51
; 0000 072B nop ;2
nop ;2
; 0000 072C nop ;3
nop ;3
; 0000 072D nop ;4
nop ;4
; 0000 072E nop ;5
nop ;5
; 0000 072F nop ;6
nop ;6
; 0000 0730 nop ;7
nop ;7
; 0000 0731 nop ;8
nop ;8
; 0000 0732 nop ;9
nop ;9
; 0000 0733 nop ;10
nop ;10
; 0000 0734 nop ;11
nop ;11
; 0000 0735 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0736 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0737     inc r19 ;16
    inc r19 ;16
; 0000 0738      out PORTC,r19 ;1-52
     out PORTC,r19 ;1-52
; 0000 0739 nop ;2
nop ;2
; 0000 073A nop ;3
nop ;3
; 0000 073B nop ;4
nop ;4
; 0000 073C nop ;5
nop ;5
; 0000 073D nop ;6
nop ;6
; 0000 073E nop ;7
nop ;7
; 0000 073F nop ;8
nop ;8
; 0000 0740 nop ;9
nop ;9
; 0000 0741 nop ;10
nop ;10
; 0000 0742 nop ;11
nop ;11
; 0000 0743 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0744 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0745     inc r19 ;16
    inc r19 ;16
; 0000 0746      out PORTC,r19 ;1-53
     out PORTC,r19 ;1-53
; 0000 0747 nop ;2
nop ;2
; 0000 0748 nop ;3
nop ;3
; 0000 0749 nop ;4
nop ;4
; 0000 074A nop ;5
nop ;5
; 0000 074B nop ;6
nop ;6
; 0000 074C nop ;7
nop ;7
; 0000 074D nop ;8
nop ;8
; 0000 074E nop ;9
nop ;9
; 0000 074F nop ;10
nop ;10
; 0000 0750 nop ;11
nop ;11
; 0000 0751 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0752 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0753     inc r19 ;16
    inc r19 ;16
; 0000 0754      out PORTC,r19 ;1-54
     out PORTC,r19 ;1-54
; 0000 0755 nop ;2
nop ;2
; 0000 0756 nop ;3
nop ;3
; 0000 0757 nop ;4
nop ;4
; 0000 0758 nop ;5
nop ;5
; 0000 0759 nop ;6
nop ;6
; 0000 075A nop ;7
nop ;7
; 0000 075B nop ;8
nop ;8
; 0000 075C nop ;9
nop ;9
; 0000 075D nop ;10
nop ;10
; 0000 075E nop ;11
nop ;11
; 0000 075F cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0760 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0761     inc r19 ;16
    inc r19 ;16
; 0000 0762      out PORTC,r19 ;1-55
     out PORTC,r19 ;1-55
; 0000 0763 nop ;2
nop ;2
; 0000 0764 nop ;3
nop ;3
; 0000 0765 nop ;4
nop ;4
; 0000 0766 nop ;5
nop ;5
; 0000 0767 nop ;6
nop ;6
; 0000 0768 nop ;7
nop ;7
; 0000 0769 nop ;8
nop ;8
; 0000 076A nop ;9
nop ;9
; 0000 076B nop ;10
nop ;10
; 0000 076C nop ;11
nop ;11
; 0000 076D cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 076E SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 076F     inc r19 ;16
    inc r19 ;16
; 0000 0770      out PORTC,r19 ;1-56
     out PORTC,r19 ;1-56
; 0000 0771 nop ;2
nop ;2
; 0000 0772 nop ;3
nop ;3
; 0000 0773 nop ;4
nop ;4
; 0000 0774 nop ;5
nop ;5
; 0000 0775 nop ;6
nop ;6
; 0000 0776 nop ;7
nop ;7
; 0000 0777 nop ;8
nop ;8
; 0000 0778 nop ;9
nop ;9
; 0000 0779 nop ;10
nop ;10
; 0000 077A nop ;11
nop ;11
; 0000 077B cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 077C SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 077D     inc r19 ;16
    inc r19 ;16
; 0000 077E      out PORTC,r19 ;1-57
     out PORTC,r19 ;1-57
; 0000 077F nop ;2
nop ;2
; 0000 0780 nop ;3
nop ;3
; 0000 0781 nop ;4
nop ;4
; 0000 0782 nop ;5
nop ;5
; 0000 0783 nop ;6
nop ;6
; 0000 0784 nop ;7
nop ;7
; 0000 0785 nop ;8
nop ;8
; 0000 0786 nop ;9
nop ;9
; 0000 0787 nop ;10
nop ;10
; 0000 0788 nop ;11
nop ;11
; 0000 0789 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 078A SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 078B     inc r19 ;16
    inc r19 ;16
; 0000 078C      out PORTC,r19 ;1-58
     out PORTC,r19 ;1-58
; 0000 078D nop ;2
nop ;2
; 0000 078E nop ;3
nop ;3
; 0000 078F nop ;4
nop ;4
; 0000 0790 nop ;5
nop ;5
; 0000 0791 nop ;6
nop ;6
; 0000 0792 nop ;7
nop ;7
; 0000 0793 nop ;8
nop ;8
; 0000 0794 nop ;9
nop ;9
; 0000 0795 nop ;10
nop ;10
; 0000 0796 nop ;11
nop ;11
; 0000 0797 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0798 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0799     inc r19 ;16
    inc r19 ;16
; 0000 079A      out PORTC,r19 ;1-59
     out PORTC,r19 ;1-59
; 0000 079B nop ;2
nop ;2
; 0000 079C nop ;3
nop ;3
; 0000 079D nop ;4
nop ;4
; 0000 079E nop ;5
nop ;5
; 0000 079F nop ;6
nop ;6
; 0000 07A0 nop ;7
nop ;7
; 0000 07A1 nop ;8
nop ;8
; 0000 07A2 nop ;9
nop ;9
; 0000 07A3 nop ;10
nop ;10
; 0000 07A4 nop ;11
nop ;11
; 0000 07A5 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 07A6 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 07A7 nop ;16
nop ;16
; 0000 07A8 nop ;1
nop ;1
; 0000 07A9 nop ;2
nop ;2
; 0000 07AA nop ;3
nop ;3
; 0000 07AB nop ;4
nop ;4
; 0000 07AC nop ;5
nop ;5
; 0000 07AD nop ;6
nop ;6
; 0000 07AE nop ;7
nop ;7
; 0000 07AF nop ;8
nop ;8
; 0000 07B0 nop ;9
nop ;9
; 0000 07B1 nop ;10
nop ;10
; 0000 07B2 nop ;11
nop ;11
; 0000 07B3 nop ;12
nop ;12
; 0000 07B4 nop ;13
nop ;13
; 0000 07B5 nop ;14
nop ;14
; 0000 07B6  nop;
 nop;
; 0000 07B7     cbi  PORTB,3;16-17  Blank =0
    cbi  PORTB,3;16-17  Blank =0
; 0000 07B8     ;clr r19 ;18
    ;clr r19 ;18
; 0000 07B9     ldi r19,4 ;18  ""
    ldi r19,4 ;18  ""
; 0000 07BA     out PORTC,r19 ;19
    out PORTC,r19 ;19
; 0000 07BB 

; 0000 07BC #endasm
; 0000 07BD  L2:
_0x15:
; 0000 07BE        V++; //
	MOVW R30,R6
	ADIW R30,1
	MOVW R6,R30
; 0000 07BF  L1:
_0xC:
; 0000 07C0    CV++;  //
	MOVW R30,R4
	ADIW R30,1
	MOVW R4,R30
; 0000 07C1 }
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R25,Y+
	LD   R24,Y+
	RETI
;
;// Declare your global variables here
;
;void main(void)
; 0000 07C6 {
_main:
; 0000 07C7 // Declare your local variables here
; 0000 07C8 
; 0000 07C9 // Crystal Oscillator division factor: 1
; 0000 07CA #pragma optsize-
; 0000 07CB CLKPR=0x80;
	LDI  R30,LOW(128)
	STS  97,R30
; 0000 07CC CLKPR=0x00;
	LDI  R30,LOW(0)
	STS  97,R30
; 0000 07CD #ifdef _OPTIMIZE_SIZE_
; 0000 07CE #pragma optsize+
; 0000 07CF #endif
; 0000 07D0 
; 0000 07D1 // Input/Output Ports initialization
; 0000 07D2 // Port B initialization
; 0000 07D3 // Func7=In Func6=In Func5=In Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out
; 0000 07D4 // State7=T State6=T State5=P State4=1 State3=1 State2=1 State1=1 State0=1
; 0000 07D5 PORTB=0x3F;
	LDI  R30,LOW(63)
	OUT  0x5,R30
; 0000 07D6 DDRB=0x1F;
	LDI  R30,LOW(31)
	OUT  0x4,R30
; 0000 07D7 
; 0000 07D8 // Port C initialization
; 0000 07D9 // Func6=In Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out
; 0000 07DA // State6=T State5=0 State4=0 State3=0 State2=0 State1=0 State0=0
; 0000 07DB PORTC=0x00;
	LDI  R30,LOW(0)
	OUT  0x8,R30
; 0000 07DC DDRC=0x3F;
	LDI  R30,LOW(63)
	OUT  0x7,R30
; 0000 07DD 
; 0000 07DE // Port D initialization
; 0000 07DF // Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out
; 0000 07E0 // State7=0 State6=0 State5=0 State4=0 State3=0 State2=0 State1=0 State0=0
; 0000 07E1 PORTD=0x00;
	LDI  R30,LOW(0)
	OUT  0xB,R30
; 0000 07E2 DDRD=0xFF;
	LDI  R30,LOW(255)
	OUT  0xA,R30
; 0000 07E3 
; 0000 07E4 // Timer/Counter 0 initialization
; 0000 07E5 // Clock source: System Clock
; 0000 07E6 // Clock value: Timer 0 Stopped
; 0000 07E7 // Mode: Normal top=FFh
; 0000 07E8 // OC0A output: Disconnected
; 0000 07E9 // OC0B output: Disconnected
; 0000 07EA TCCR0A=0x00;
	LDI  R30,LOW(0)
	OUT  0x24,R30
; 0000 07EB TCCR0B=0x00;
	OUT  0x25,R30
; 0000 07EC TCNT0=0x00;
	OUT  0x26,R30
; 0000 07ED OCR0A=0x00;
	OUT  0x27,R30
; 0000 07EE OCR0B=0x00;
	OUT  0x28,R30
; 0000 07EF 
; 0000 07F0 // Timer/Counter 1 initialization
; 0000 07F1 // Clock source: System Clock
; 0000 07F2 // Clock value: 20000,000 kHz
; 0000 07F3 // Mode: Fast PWM top=ICR1
; 0000 07F4 // OC1A output: Inverted
; 0000 07F5 // OC1B output: Discon.
; 0000 07F6 // Noise Canceler: Off
; 0000 07F7 // Input Capture on Falling Edge
; 0000 07F8 // Timer1 Overflow Interrupt: Off
; 0000 07F9 // Input Capture Interrupt: Off
; 0000 07FA // Compare A Match Interrupt: On
; 0000 07FB // Compare B Match Interrupt: Off
; 0000 07FC TCCR1A=0xC2;
	LDI  R30,LOW(194)
	STS  128,R30
; 0000 07FD TCCR1B=0x19;
	LDI  R30,LOW(25)
	STS  129,R30
; 0000 07FE TCNT1H=0x00;
	LDI  R30,LOW(0)
	STS  133,R30
; 0000 07FF TCNT1L=0x00;
	STS  132,R30
; 0000 0800 ICR1H=0x04;    // 
	LDI  R30,LOW(4)
	STS  135,R30
; 0000 0801 ICR1L=0xFF;    //       
	LDI  R30,LOW(255)
	STS  134,R30
; 0000 0802 OCR1AH=0x00;   //
	LDI  R30,LOW(0)
	STS  137,R30
; 0000 0803 OCR1AL=0x5D;   //            
	LDI  R30,LOW(93)
	STS  136,R30
; 0000 0804 OCR1BH=0x00;
	LDI  R30,LOW(0)
	STS  139,R30
; 0000 0805 OCR1BL=0x00;
	STS  138,R30
; 0000 0806 
; 0000 0807 // Timer/Counter 2 initialization
; 0000 0808 // Clock source: System Clock
; 0000 0809 // Clock value: Timer2 Stopped
; 0000 080A // Mode: Normal top=FFh
; 0000 080B // OC2A output: Disconnected
; 0000 080C // OC2B output: Disconnected
; 0000 080D ASSR=0x00;
	STS  182,R30
; 0000 080E TCCR2A=0x00;
	STS  176,R30
; 0000 080F TCCR2B=0x00;
	STS  177,R30
; 0000 0810 TCNT2=0x00;
	STS  178,R30
; 0000 0811 OCR2A=0x00;
	STS  179,R30
; 0000 0812 OCR2B=0x00;
	STS  180,R30
; 0000 0813 
; 0000 0814 // External Interrupt(s) initialization
; 0000 0815 // INT0: Off
; 0000 0816 // INT1: Off
; 0000 0817 // Interrupt on any change on pins PCINT0-7: Off
; 0000 0818 // Interrupt on any change on pins PCINT8-14: Off
; 0000 0819 // Interrupt on any change on pins PCINT16-23: Off
; 0000 081A EICRA=0x00;
	STS  105,R30
; 0000 081B EIMSK=0x00;
	OUT  0x1D,R30
; 0000 081C PCICR=0x00;
	STS  104,R30
; 0000 081D 
; 0000 081E // Timer/Counter 0 Interrupt(s) initialization
; 0000 081F TIMSK0=0x00;
	STS  110,R30
; 0000 0820 // Timer/Counter 1 Interrupt(s) initialization
; 0000 0821 TIMSK1=0x02;
	LDI  R30,LOW(2)
	STS  111,R30
; 0000 0822 // Timer/Counter 2 Interrupt(s) initialization
; 0000 0823 TIMSK2=0x00;
	LDI  R30,LOW(0)
	STS  112,R30
; 0000 0824 
; 0000 0825 // Analog Comparator initialization
; 0000 0826 // Analog Comparator: Off
; 0000 0827 // Analog Comparator Input Capture by Timer/Counter 1: Off
; 0000 0828 ACSR=0x80;
	LDI  R30,LOW(128)
	OUT  0x30,R30
; 0000 0829 ADCSRB=0x00;
	LDI  R30,LOW(0)
	STS  123,R30
; 0000 082A 
; 0000 082B // Global enable interrupts
; 0000 082C #asm("sei")
	sei
; 0000 082D 
; 0000 082E while (1)
_0x16:
; 0000 082F       {
; 0000 0830 
; 0000 0831 
; 0000 0832 
; 0000 0833       };
	RJMP _0x16
; 0000 0834 }
_0x19:
	RJMP _0x19

	.CSEG

	.CSEG
;END OF CODE MARKER
__END_OF_CODE:
